/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Subscription;

public class Producer
extends Subscription {
    protected ClientType clientType;
    protected ProducerPolicy producerPolicy;
    protected ProducerLimitPolicy limitPolicy;

    public Producer() {
        this.setType(Subscription.Type.PRODUCTION);
    }

    public String getId() {
        return this.topic.getFullName() + "." + this.app;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public ProducerPolicy getProducerPolicy() {
        return this.producerPolicy;
    }

    public void setProducerPolicy(ProducerPolicy producerPolicy) {
        this.producerPolicy = producerPolicy;
    }

    public void setLimitPolicy(ProducerLimitPolicy limitPolicy) {
        this.limitPolicy = limitPolicy;
    }

    public ProducerLimitPolicy getLimitPolicy() {
        return this.limitPolicy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Producer)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Producer producer = (Producer)o;
        return this.clientType == producer.clientType && Objects.equals(this.producerPolicy, producer.producerPolicy) && Objects.equals(this.limitPolicy, producer.limitPolicy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.clientType, this.producerPolicy, this.limitPolicy});
    }

    public static class ProducerPolicy
    implements Serializable {
        private Boolean nearby;
        private Boolean single;
        private Boolean archive;
        private Map<String, Short> weight;
        private Set<String> blackList;
        private Integer timeOut;

        public ProducerPolicy() {
            this.nearby = false;
            this.single = false;
            this.archive = false;
            this.timeOut = 10000;
        }

        public ProducerPolicy(Boolean nearby, boolean single, Boolean archive, Map<String, Short> weight, Set<String> blackList, Integer timeOut) {
            this.nearby = nearby;
            this.single = single;
            this.archive = archive;
            this.weight = weight;
            this.blackList = blackList;
            this.timeOut = timeOut;
        }

        public Boolean getNearby() {
            return this.nearby;
        }

        public Map<String, Short> getWeight() {
            return this.weight;
        }

        public Set<String> getBlackList() {
            return this.blackList;
        }

        public Boolean isSingle() {
            return this.single;
        }

        public Boolean getArchive() {
            return this.archive;
        }

        public Integer getTimeOut() {
            return this.timeOut;
        }

        public void setNearby(Boolean nearby) {
            this.nearby = nearby;
        }

        public void setSingle(Boolean single) {
            this.single = single;
        }

        public void setArchive(Boolean archive) {
            this.archive = archive;
        }

        public void setWeight(Map<String, Short> weight) {
            this.weight = weight;
        }

        public void setBlackList(Set<String> blackList) {
            this.blackList = blackList;
        }

        public void setTimeOut(Integer timeOut) {
            this.timeOut = timeOut;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProducerPolicy that = (ProducerPolicy)o;
            return Objects.equals(this.nearby, that.nearby) && Objects.equals(this.single, that.single) && Objects.equals(this.archive, that.archive) && Objects.equals(this.weight, that.weight) && Objects.equals(this.blackList, that.blackList) && Objects.equals(this.timeOut, that.timeOut);
        }

        public int hashCode() {
            return Objects.hash(this.nearby, this.single, this.archive, this.weight, this.blackList, this.timeOut);
        }

        public static class Builder {
            private Boolean nearby = Boolean.FALSE;
            private boolean single = Boolean.FALSE;
            private Boolean archive = Boolean.FALSE;
            private Map<String, Short> weight;
            private Set<String> blackList;
            private Integer timeOut = 5000;

            public static Builder build() {
                return new Builder();
            }

            public Builder nearby(Boolean nearby) {
                this.nearby = nearby;
                return this;
            }

            public Builder archive(Boolean archive) {
                this.archive = archive;
                return this;
            }

            public Builder single(Boolean single) {
                this.single = single;
                return this;
            }

            public Builder blackList(String blackList) {
                if (null != blackList && !"".equals(blackList.trim())) {
                    this.blackList = new HashSet<String>(Arrays.asList(blackList.trim().split(",")));
                }
                return this;
            }

            public Builder weight(String weight) {
                if (null != weight && !"".equals(weight.trim())) {
                    String[] weights;
                    this.weight = new HashMap<String, Short>();
                    for (String s : weights = weight.trim().split(",")) {
                        String[] m = s.split(":");
                        this.weight.put(m[0].trim(), Short.valueOf(m[1].trim()));
                    }
                }
                return this;
            }

            public Builder timeout(Integer timeOut) {
                this.timeOut = timeOut;
                return this;
            }

            public ProducerPolicy create() {
                return new ProducerPolicy(this.nearby, this.single, this.archive, this.weight, this.blackList, this.timeOut);
            }
        }
    }

    public static class ProducerLimitPolicy
    implements Serializable {
        private Integer tps;
        private Integer traffic;

        public ProducerLimitPolicy() {
        }

        public ProducerLimitPolicy(Integer tps, Integer traffic) {
            this.tps = tps;
            this.traffic = traffic;
        }

        public void setTps(Integer tps) {
            this.tps = tps;
        }

        public Integer getTps() {
            return this.tps;
        }

        public void setTraffic(Integer traffic) {
            this.traffic = traffic;
        }

        public Integer getTraffic() {
            return this.traffic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProducerLimitPolicy that = (ProducerLimitPolicy)o;
            return Objects.equals(this.tps, that.tps) && Objects.equals(this.traffic, that.traffic);
        }

        public int hashCode() {
            return Objects.hash(this.tps, this.traffic);
        }
    }
}

