/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.joyqueue.domain.TopicName;

public class Topic
implements Serializable {
    protected TopicName name;
    protected short partitions;
    protected Type type = Type.TOPIC;
    protected Set<Short> priorityPartitions = new TreeSet<Short>();

    public TopicName getName() {
        return this.name;
    }

    public void setName(TopicName name) {
        this.name = name;
    }

    public short getPartitions() {
        return this.partitions;
    }

    public void setPartitions(short partitions) {
        this.partitions = partitions;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Set<Short> getPriorityPartitions() {
        return this.priorityPartitions;
    }

    public void setPriorityPartitions(Set<Short> priorityPartitions) {
        this.priorityPartitions = priorityPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Topic)) {
            return false;
        }
        Topic topic = (Topic)o;
        return this.partitions == topic.partitions && Objects.equals(this.name, topic.name) && this.type == topic.type && Objects.equals(this.priorityPartitions, topic.priorityPartitions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.partitions, this.type, this.priorityPartitions);
    }

    public static enum Type implements Serializable
    {
        TOPIC(0, "\u666e\u901a\u4e3b\u9898"),
        BROADCAST(1, "\u5e7f\u64ad"),
        SEQUENTIAL(2, "\u987a\u5e8f\u4e3b\u9898");

        private final byte code;
        private final String name;

        private Type(byte code, String name) {
            this.code = code;
            this.name = name;
        }

        public byte code() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public static Type valueOf(byte value) {
            for (Type type : Type.values()) {
                if (value != type.code) continue;
                return type;
            }
            return TOPIC;
        }
    }
}

