/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Partition;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Topic;

public class TopicConfig
extends Topic
implements Serializable {
    private Map<Short, PartitionGroup> partitionGroupMap = new HashMap<Short, PartitionGroup>();
    private Map<Integer, PartitionGroup> partitionGroups;

    public static TopicConfig toTopicConfig(Topic topic) {
        if (topic == null) {
            return null;
        }
        TopicConfig config = new TopicConfig();
        config.setName(topic.getName());
        config.setPartitions(topic.getPartitions());
        config.setType(topic.getType());
        config.setPriorityPartitions(topic.getPriorityPartitions());
        return config;
    }

    public static TopicConfig toTopicConfig(Topic topic, List<PartitionGroup> partitionGroups) {
        if (topic == null) {
            return null;
        }
        TopicConfig config = TopicConfig.toTopicConfig(topic);
        HashMap partitionGroupMap = Maps.newHashMap();
        for (PartitionGroup partitionGroup : partitionGroups) {
            partitionGroupMap.put(partitionGroup.getGroup(), partitionGroup);
        }
        config.setPartitionGroups(partitionGroupMap);
        return config;
    }

    public TopicConfig clone() {
        TopicConfig topicConfig = TopicConfig.toTopicConfig(this);
        HashMap partitionGroups = Maps.newHashMap();
        for (Map.Entry<Integer, PartitionGroup> entry : this.getPartitionGroups().entrySet()) {
            partitionGroups.put(entry.getKey(), entry.getValue().clone());
        }
        topicConfig.setPartitionGroups(partitionGroups);
        return topicConfig;
    }

    public Map<Integer, PartitionGroup> getPartitionGroups() {
        return this.partitionGroups;
    }

    public boolean isReplica(int brokerId) {
        for (Map.Entry<Integer, PartitionGroup> entry : this.partitionGroups.entrySet()) {
            if (!entry.getValue().getReplicas().contains(brokerId)) continue;
            return true;
        }
        return false;
    }

    public List<PartitionGroup> fetchTopicPartitionGroupsByBrokerId(int brokerId) {
        ArrayList<PartitionGroup> list = new ArrayList<PartitionGroup>();
        for (PartitionGroup group : this.partitionGroups.values()) {
            if (!group.getReplicas().contains(brokerId)) continue;
            list.add(group);
        }
        return list;
    }

    public void setPartitionGroups(Map<Integer, PartitionGroup> partitionGroups) {
        this.partitionGroups = partitionGroups;
        this.partitionGroupMap = this.buildPartitionGroupMap(partitionGroups);
    }

    private Map<Short, PartitionGroup> buildPartitionGroupMap(Map<Integer, PartitionGroup> partitionGroups) {
        HashMap result = Maps.newHashMap();
        if (MapUtils.isEmpty(partitionGroups)) {
            return result;
        }
        for (PartitionGroup partitionGroup : partitionGroups.values()) {
            for (Short partition : partitionGroup.getPartitions()) {
                result.put(partition, partitionGroup);
            }
        }
        return result;
    }

    public PartitionGroup fetchPartitionGroupByPartition(short partition) {
        return this.partitionGroupMap.get(partition);
    }

    public PartitionGroup fetchPartitionGroupByGroup(int group) {
        return this.partitionGroups.get(group);
    }

    public Broker fetchBrokerByPartition(short partition) {
        PartitionGroup group = this.fetchPartitionGroupByPartition(partition);
        if (null != group) {
            return group.getBrokers().get(group.getLeader());
        }
        return null;
    }

    public List<Partition> fetchPartitionMetadata() {
        ArrayList<Partition> metadataList = new ArrayList<Partition>();
        for (PartitionGroup group : this.partitionGroups.values()) {
            for (Short partition : group.getPartitions()) {
                HashSet<Broker> isrs = new HashSet<Broker>(null == group.getIsrs() ? 0 : group.getIsrs().size());
                HashSet<Broker> replicas = new HashSet<Broker>(null == group.getReplicas() ? 0 : group.getReplicas().size());
                if (null != group.getIsrs()) {
                    for (Integer brokerId : group.getIsrs()) {
                        if (group.getBrokers().get(brokerId) == null) continue;
                        isrs.add(group.getBrokers().get(brokerId));
                    }
                }
                if (null != group.getReplicas()) {
                    for (Integer brokerId : group.getReplicas()) {
                        if (group.getBrokers().get(brokerId) == null) continue;
                        replicas.add(group.getBrokers().get(brokerId));
                    }
                }
                metadataList.add(new Partition(partition, group.getBrokers().get(group.getLeader()), replicas, isrs));
            }
        }
        return metadataList;
    }

    public Map<Integer, Broker> fetchAllBroker() {
        HashMap<Integer, Broker> brokers = new HashMap<Integer, Broker>();
        for (PartitionGroup group : this.partitionGroups.values()) {
            brokers.putAll(group.getBrokers());
        }
        return brokers;
    }

    public Set<Integer> fetchAllBrokerIds() {
        HashSet<Integer> brokers = new HashSet<Integer>();
        for (PartitionGroup group : this.partitionGroups.values()) {
            brokers.addAll(group.getReplicas());
        }
        return brokers;
    }

    public Set<Short> fetchAllPartitions() {
        HashSet<Short> partitions = new HashSet<Short>();
        for (PartitionGroup group : this.partitionGroups.values()) {
            partitions.addAll(group.getPartitions());
        }
        return partitions;
    }

    public boolean checkSequential() {
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TopicConfig)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return super.equals(((TopicConfig)o).getName());
    }

    public String toString() {
        return "TopicConfig{topic='" + this.name.getFullName() + '\'' + ", partitions=" + this.partitions + ", type=" + this.type + ", priorityPartitions=" + (null == this.priorityPartitions ? "[]" : Arrays.toString(this.priorityPartitions.toArray())) + ", partitionGroups=" + this.partitionGroups + ", partitionGroupMap=" + this.partitionGroupMap + '}';
    }
}

