/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class TopicName {
    public static final String DEFAULT_NAMESPACE = "";
    public static final String TOPIC_SEPARATOR = ".";
    public static final String TOPIC_SEPARATOR_SPLIT = ".";
    private static final int TOPIC_NAME_CACHE_SIZE = 10240;
    private static final ConcurrentMap<String, TopicName> TOPIC_NAME_CACHE = Maps.newConcurrentMap();
    private String code;
    private String namespace;
    private String fullName;

    public TopicName() {
    }

    public TopicName(String code) {
        this(code, DEFAULT_NAMESPACE);
    }

    public TopicName(String code, String namespace) {
        Preconditions.checkArgument((code != null && !code.isEmpty() && !code.contains(".") ? 1 : 0) != 0, (Object)"invalid topic.");
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"invalid name space.");
        this.code = code;
        this.namespace = namespace;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = DEFAULT_NAMESPACE.equals(this.namespace) ? this.code : this.namespace + "." + this.code;
        }
        return this.fullName;
    }

    public static TopicName parse(String code, String namespace) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            namespace = DEFAULT_NAMESPACE;
        }
        return new TopicName(code, namespace);
    }

    public static TopicName parse(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        TopicName topicName = (TopicName)TOPIC_NAME_CACHE.get(fullName);
        if (topicName == null) {
            String[] splits;
            if (TOPIC_NAME_CACHE.size() > 10240) {
                TOPIC_NAME_CACHE.clear();
            }
            topicName = (splits = StringUtils.splitByWholeSeparator((String)fullName, (String)".")).length == 1 ? new TopicName(splits[0]) : new TopicName(splits[1], splits[0]);
            TOPIC_NAME_CACHE.put(fullName, topicName);
        }
        return topicName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String topic) {
        this.code = topic;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof TopicName)) {
            return false;
        }
        TopicName that = (TopicName)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.namespace);
    }

    public String toString() {
        return "TopicName{code='" + this.code + '\'' + ", namespace='" + this.namespace + '\'' + '}';
    }
}

