/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.message;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.joyqueue.toolkit.io.Compressor;
import org.joyqueue.toolkit.io.Compressors;
import org.joyqueue.toolkit.io.Snappy;
import org.joyqueue.toolkit.io.Zip;
import org.joyqueue.toolkit.io.Zlib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
implements Serializable {
    public static final String TAGS = "TAGS";
    public static final int COMPRESS_THRESHOLD = 100;
    public static String EXPIRE = "EXPIRE";
    protected static final Logger logger = LoggerFactory.getLogger(Message.class);
    protected short partition = (short)-1;
    protected String topic;
    protected short flag;
    protected String app;
    protected String businessId;
    protected byte priority;
    protected boolean compressed;
    protected CompressionType compressionType;
    protected boolean ordered;
    protected String text;
    protected long bodyCRC;
    protected byte[] body;
    protected Map<String, String> attributes;
    protected String txId;

    @Deprecated
    public Message() {
    }

    @Deprecated
    public Message(String topic, String text, String businessId) {
        this.setTopic(topic);
        this.setBusinessId(businessId);
        this.setText(text);
    }

    @Deprecated
    public Message(String topic, String text, String businessId, CompressionType compressionType) {
        this.setTopic(topic);
        this.setBusinessId(businessId);
        this.setCompressionType(compressionType);
        this.setText(text);
    }

    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public Message topic(String topic) {
        this.setTopic(topic);
        return this;
    }

    public Message flag(short flag) {
        this.setFlag(flag);
        return this;
    }

    public Message app(String app) {
        this.setApp(app);
        return this;
    }

    public Message businessId(String businessId) {
        this.setBusinessId(businessId);
        return this;
    }

    public Message priority(byte priority) {
        this.setPriority(priority);
        return this;
    }

    public Message ordered(boolean ordered) {
        this.setOrdered(ordered);
        return this;
    }

    public Message text(String text) {
        this.setText(text);
        return this;
    }

    public Message body(byte[] data) {
        this.setBody(data, 0, data.length);
        return this;
    }

    public Message attribute(String key, String value) {
        this.setAttribute(key, value);
        return this;
    }

    public Message attributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Message partition(short partition) {
        this.setPartition(partition);
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public short getFlag() {
        return this.flag;
    }

    public void setFlag(short flag) {
        this.flag = flag;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public CompressionType getCompressionType() {
        if (!this.isCompressed()) {
            return CompressionType.none;
        }
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public short getPartition() {
        return this.partition;
    }

    public void setPartition(short partition) {
        this.partition = partition;
    }

    public long getBodyCRC() {
        return this.bodyCRC;
    }

    public void setBodyCRC(long bodyCRC) {
        this.bodyCRC = bodyCRC;
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body);
    }

    public void setBody(ByteBuffer buf) {
        if (buf.hasArray()) {
            byte[] data = buf.array();
            int offset = 0;
            int length = 0;
            offset = buf.arrayOffset() + buf.position();
            length = buf.remaining();
            byte[] dest = new byte[length];
            System.arraycopy(data, offset, dest, 0, length);
            this.setBody(dest);
        } else {
            byte[] data = new byte[buf.remaining()];
            buf.get(data);
            this.setBody(data);
        }
    }

    public byte[] getByteBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
        CRC32 crc32 = new CRC32();
        crc32.update(body);
        this.bodyCRC = crc32.getValue();
    }

    public void setBody(byte[] data, int offset, int length) {
        if (offset == 0 && length == data.length) {
            this.setBody(data);
        } else {
            int remain = length;
            int srcLen = data.length;
            if (remain > srcLen - offset) {
                remain = srcLen - offset;
            }
            byte[] dest = new byte[remain];
            System.arraycopy(data, offset, dest, 0, remain);
            this.setBody(dest);
        }
    }

    public String getText() {
        if (this.text == null && this.body != null) {
            try {
                if (this.compressed) {
                    byte[] data = null;
                    switch (this.compressionType) {
                        case Zip: {
                            data = Compressors.decompress((byte[])this.body, (int)0, (int)this.body.length, (Compressor)Zip.INSTANCE);
                            break;
                        }
                        case ZLIB: {
                            data = Compressors.decompress((byte[])this.body, (int)0, (int)this.body.length, (Compressor)Zlib.INSTANCE);
                            break;
                        }
                        case Snappy: {
                            data = Compressors.decompress((byte[])this.body, (int)0, (int)this.body.length, (Compressor)Snappy.INSTANCE);
                        }
                    }
                    this.text = new String(data, Charset.forName("UTF-8"));
                } else {
                    this.text = new String(this.body, Charset.forName("UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("decode body error.", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("decompress body error.", e);
            }
        }
        return this.text;
    }

    public byte[] getDecompressedBody() {
        try {
            if (this.compressed) {
                switch (this.compressionType) {
                    case none: {
                        return this.body;
                    }
                    case Zip: {
                        return Compressors.decompress((byte[])this.body, (int)0, (int)this.body.length, (Compressor)Zip.INSTANCE);
                    }
                    case Snappy: {
                        return Compressors.decompress((byte[])this.body, (int)0, (int)this.body.length, (Compressor)Snappy.INSTANCE);
                    }
                    case ZLIB: {
                        return Compressors.decompress((byte[])this.body, (int)0, (int)this.body.length, (Compressor)Zlib.INSTANCE);
                    }
                }
                return this.body;
            }
            return this.body;
        }
        catch (Exception e) {
            logger.error("getDecompressedBody error, topic: {}, app: {}", new Object[]{this.topic, this.app, e});
            return this.body;
        }
    }

    @Deprecated
    public void setText(String text) {
        this.text = text;
        this.compressed = false;
        byte[] data = text == null ? new byte[]{} : text.getBytes(Charset.forName("UTF-8"));
        if (data.length >= 100) {
            try {
                data = Compressors.compress((byte[])data, (int)0, (int)data.length, (Compressor)(this.compressionType != CompressionType.Snappy ? Zip.INSTANCE : Snappy.INSTANCE));
                this.compressed = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.body = data;
        this.bodyCRC = 0L;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, value);
    }

    public String getTags() {
        return this.getAttribute(TAGS);
    }

    public void setTags(String tags) {
        this.setAttribute(TAGS, tags);
    }

    public long getExpire() {
        String value = this.getAttribute(EXPIRE);
        if (value == null) {
            return 0L;
        }
        return Long.valueOf(value);
    }

    public void setExpire(long expire) {
        this.setAttribute(EXPIRE, String.valueOf(expire));
    }

    public int getSize() {
        if (this.body != null) {
            return this.body.length;
        }
        if (this.text != null) {
            byte[] bytes = this.text.getBytes(Charset.forName("UTF-8"));
            return bytes.length;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (this.bodyCRC != message.bodyCRC) {
            return false;
        }
        if (this.compressed != message.compressed) {
            return false;
        }
        if (this.flag != message.flag) {
            return false;
        }
        if (this.ordered != message.ordered) {
            return false;
        }
        if (this.priority != message.priority) {
            return false;
        }
        if (this.app != null ? !this.app.equals(message.app) : message.app != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(message.attributes) : message.attributes != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(message.body) : message.body != null) {
            return false;
        }
        if (this.businessId != null ? !this.businessId.equals(message.businessId) : message.businessId != null) {
            return false;
        }
        return !(this.topic != null ? !this.topic.equals(message.topic) : message.topic != null);
    }

    public int hashCode() {
        int result = this.compressed ? 1 : 0;
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + this.flag;
        result = 31 * result + (this.app != null ? this.app.hashCode() : 0);
        result = 31 * result + (this.businessId != null ? this.businessId.hashCode() : 0);
        result = 31 * result + this.priority;
        result = 31 * result + (this.ordered ? 1 : 0);
        result = 31 * result + (int)(this.bodyCRC ^ this.bodyCRC >>> 32);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public static enum CompressionType {
        none(0),
        Zip(1),
        ZLIB(2),
        Snappy(3);

        private int type;

        private CompressionType(int type) {
            this.type = type;
        }

        public static CompressionType valueOf(int value) {
            switch (value) {
                case 0: {
                    return none;
                }
                case 1: {
                    return Zip;
                }
                case 2: {
                    return ZLIB;
                }
                case 3: {
                    return Snappy;
                }
            }
            throw new UnsupportedOperationException("unsupported type, type: " + value);
        }

        public static CompressionType convert(String value) {
            for (CompressionType compressionType : CompressionType.values()) {
                if (!compressionType.name().equalsIgnoreCase(value)) continue;
                return compressionType;
            }
            return null;
        }

        public int getType() {
            return this.type;
        }
    }
}

