/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.message;

import java.util.Arrays;
import org.joyqueue.toolkit.network.IpUtil;

public class MessageId {
    private byte[] address;
    private long offset;
    private String messageId;

    public MessageId(String messageId) {
        if (messageId == null || messageId.isEmpty()) {
            throw new IllegalArgumentException("messageId is invalid");
        }
        int pos = messageId.indexOf(45);
        if (pos < 0) {
            throw new IllegalArgumentException("messageId is invalid");
        }
        String[] parts = new String[]{messageId.substring(0, pos), messageId.substring(pos + 1)};
        if (parts[0] == null || parts[0].isEmpty() || parts[1] == null || parts[1].isEmpty()) {
            throw new IllegalArgumentException("messageId is invalid");
        }
        this.offset = Long.valueOf(parts[1]);
        if (this.offset < 0L) {
            throw new IllegalArgumentException("messageId is invalid");
        }
        this.address = IpUtil.toByte((String)parts[0]);
    }

    public MessageId(byte[] address, long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset is invalid");
        }
        if (address == null || address.length < 4) {
            throw new IllegalArgumentException("address is invalid");
        }
        this.address = address;
        this.offset = offset;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getMessageId() {
        if (this.messageId == null && this.address != null) {
            StringBuilder sb = new StringBuilder();
            this.toHex(this.address, sb);
            sb.append('-').append(this.offset);
            this.messageId = sb.toString();
        }
        return this.messageId;
    }

    public String toString() {
        return this.getMessageId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageId messageId1 = (MessageId)o;
        if (this.offset != messageId1.offset) {
            return false;
        }
        if (!Arrays.equals(this.address, messageId1.address)) {
            return false;
        }
        return !(this.messageId != null ? !this.messageId.equals(messageId1.messageId) : messageId1.messageId != null);
    }

    public int hashCode() {
        int result = this.address != null ? Arrays.hashCode(this.address) : 0;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.messageId != null ? this.messageId.hashCode() : 0);
        return result;
    }

    private void toHex(byte[] address, StringBuilder builder) {
        String hex;
        boolean hasPort;
        if (address == null || address.length == 0 || builder == null) {
            return;
        }
        int pos = 0;
        int port = 0;
        int length = address.length;
        boolean bl = hasPort = length == 6 || length == 18;
        if (hasPort) {
            port = address[pos++] & 0xFF;
            port |= address[pos++] << 8 & 0xFF00;
        }
        for (int i = 0; i < (!hasPort ? length : length - 2); ++i) {
            if ((hex = Integer.toHexString(address[pos++] & 0xFF).toUpperCase()).length() == 1) {
                builder.append('0').append(hex);
                continue;
            }
            builder.append(hex);
        }
        if (hasPort) {
            hex = Integer.toHexString(port).toUpperCase();
            int len = hex.length();
            if (len == 1) {
                builder.append("000").append(hex);
            } else if (len == 2) {
                builder.append("00").append(hex);
            } else if (len == 3) {
                builder.append("0").append(hex);
            } else {
                builder.append(hex);
            }
        }
    }
}

