/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MonitorRecord
implements Cloneable,
Serializable {
    private String provider;
    private String service;
    private String endpoint;
    private String metric;
    private double value;
    private String category;
    private long timestamp;
    private Map<String, String> tags = new HashMap<String, String>();

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.setValue(value, true);
    }

    public void setValue(double value, boolean positive) {
        if (positive) {
            value = Math.abs(value);
        }
        this.value = value;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void addTag(String key, String value) {
        this.tags.put(key, value);
    }

    public String getTag(String key) {
        return this.tags.get(key);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void brokerId(String brokerId) {
        this.tags.put("t1", brokerId);
    }

    public void host(String host) {
        this.tags.put("t2", host);
    }

    public void topic(String topic) {
        this.tags.put("t3", topic);
    }

    public void app(String app) {
        this.tags.put("t4", app);
    }

    public void partitionGroup(String partitionGroup) {
        this.tags.put("t5", partitionGroup);
    }

    public void partition(String partiton) {
        this.tags.put("t6", partiton);
    }
}

