/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model;

public class Pagination {
    private int totalRecord;
    public static final int SIZE = 10;
    public static final int MAX_SIZE = Integer.MAX_VALUE;
    private int size = 10;
    private int start = 0;
    private int page = 1;
    private int pages;

    public Pagination() {
    }

    public Pagination(int start) {
        this(start, 10);
    }

    public Pagination(int start, int size) {
        this.start = start < 0 ? 0 : start;
        this.size = size < 1 || size > Integer.MAX_VALUE ? 10 : size;
        this.page = this.start / this.size + 1;
    }

    public static Pagination newPagination(Integer start) {
        return new Pagination(start == null ? 0 : start, 10);
    }

    public static Pagination newPagination(Integer start, Integer size) {
        return new Pagination(start == null ? 0 : start, size == null ? 10 : size);
    }

    public static Pagination newPagination(Integer start, Integer page, Integer size) {
        if (page != null) {
            int v = size < 1 || size > Integer.MAX_VALUE ? 10 : size;
            int p = page <= 0 ? 1 : page;
            return Pagination.newPagination((p - 1) * v, v);
        }
        return Pagination.newPagination(start, size);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getStart() {
        if (this.page > 1) {
            this.start = (this.page - 1) * this.size;
        }
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getTotalRecord() {
        return this.totalRecord;
    }

    public void setTotalRecord(int totalRecord) {
        if (totalRecord > 0) {
            this.totalRecord = totalRecord;
            int pages = totalRecord / this.size;
            if (totalRecord % this.size > 0) {
                ++pages;
            }
            this.pages = pages;
            this.page = this.page > pages ? pages : this.page;
        }
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPages() {
        return this.pages;
    }

    public String toString() {
        return "Pagination{size=" + this.size + ", start=" + this.start + ", page=" + this.page + ", pages=" + this.pages + ", totalRecord=" + this.totalRecord + '}';
    }
}

