/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.monitor;

import java.util.Base64;
import java.util.Map;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.monitor.BaseMonitorInfo;

public class BrokerMessageInfo
extends BaseMonitorInfo {
    private long msgIndexNo;
    private int storeTime;
    private long startTime;
    private byte source;
    private short partition;
    private String topic;
    private String app;
    private String businessId;
    private byte priority;
    private long bodyCRC;
    private String body;
    private Map<String, String> attributes;
    private boolean ack;

    public BrokerMessageInfo() {
    }

    public BrokerMessageInfo(BrokerMessage message) {
        this(message, false);
    }

    public BrokerMessageInfo(BrokerMessage message, boolean ack) {
        this.msgIndexNo = message.getMsgIndexNo();
        this.storeTime = message.getStoreTime();
        this.startTime = message.getStartTime();
        this.source = message.getSource();
        this.partition = message.getPartition();
        this.topic = message.getTopic();
        this.app = message.getApp();
        this.businessId = message.getBusinessId();
        this.priority = message.getPriority();
        this.bodyCRC = message.getBodyCRC();
        byte[] bytes = message.getDecompressedBody();
        if (bytes != null && bytes.length > 0) {
            this.body = Base64.getEncoder().encodeToString(bytes);
        }
        this.attributes = message.getAttributes();
        this.ack = ack;
    }

    public long getMsgIndexNo() {
        return this.msgIndexNo;
    }

    public void setMsgIndexNo(long msgIndexNo) {
        this.msgIndexNo = msgIndexNo;
    }

    public int getStoreTime() {
        return this.storeTime;
    }

    public void setStoreTime(int storeTime) {
        this.storeTime = storeTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public byte getSource() {
        return this.source;
    }

    public void setSource(byte source) {
        this.source = source;
    }

    public short getPartition() {
        return this.partition;
    }

    public void setPartition(short partition) {
        this.partition = partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public long getBodyCRC() {
        return this.bodyCRC;
    }

    public void setBodyCRC(long bodyCRC) {
        this.bodyCRC = bodyCRC;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setAck(boolean ack) {
        this.ack = ack;
    }

    public boolean isAck() {
        return this.ack;
    }
}

