/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.monitor;

import java.io.Serializable;
import org.joyqueue.monitor.RestResponseCode;

public class RestResponse<T>
implements Serializable {
    private int code;
    private String message;
    private T data;

    public static <T> RestResponse<T> build(int code, T data) {
        return RestResponse.build(code, null, data);
    }

    public static <T> RestResponse<T> build(int code, String message) {
        return RestResponse.build(code, message, null);
    }

    public static <T> RestResponse<T> build(int code, String message, T data) {
        return new RestResponse<T>(code, message, data);
    }

    public static <T> RestResponse<T> build(RestResponseCode code, T data) {
        return RestResponse.build(code.getCode(), code.getMessage(), data);
    }

    public static <T> RestResponse<T> build(RestResponseCode code, String message) {
        return RestResponse.build(code, message, null);
    }

    public static <T> RestResponse<T> build(RestResponseCode code, String message, T data) {
        return RestResponse.build(code.getCode(), message, data);
    }

    public static <T> RestResponse<T> success() {
        return RestResponse.success(null);
    }

    public static <T> RestResponse<T> success(T data) {
        return RestResponse.build(RestResponseCode.SUCCESS, RestResponseCode.SUCCESS.getMessage(), data);
    }

    public static <T> RestResponse<T> paramError(String message) {
        return RestResponse.build(RestResponseCode.PARAM_ERROR, message, null);
    }

    public static <T> RestResponse<T> notFound(String message) {
        return RestResponse.build(RestResponseCode.NOT_FOUND, message, null);
    }

    public static <T> RestResponse<T> serverError(String message) {
        return RestResponse.build(RestResponseCode.SERVER_ERROR, message, null);
    }

    public RestResponse() {
    }

    public RestResponse(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

