/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.server.retry.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.api.RetryPolicyProvider;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.server.retry.remote.RemoteRetryProvider;
import org.joyqueue.server.retry.remote.command.GetRetry;
import org.joyqueue.server.retry.remote.command.GetRetryAck;
import org.joyqueue.server.retry.remote.command.GetRetryCount;
import org.joyqueue.server.retry.remote.command.GetRetryCountAck;
import org.joyqueue.server.retry.remote.command.PutRetry;
import org.joyqueue.server.retry.remote.command.UpdateRetry;
import org.joyqueue.server.retry.remote.config.RemoteRetryConfig;
import org.joyqueue.server.retry.remote.config.RemoteRetryConfigKey;
import org.joyqueue.toolkit.concurrent.LoopThread;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMessageRetry
implements MessageRetry<Long> {
    private static final Logger logger = LoggerFactory.getLogger(RemoteMessageRetry.class);
    private PropertySupplier propertySupplier = null;
    private int remoteRetryLimitThread = (Integer)RemoteRetryConfigKey.REMOTE_RETRY_LIMIT_THREADS.getValue();
    private long remoteRetryUpdateInterval = (Long)RemoteRetryConfigKey.REMOTE_RETRY_UPDATE_INTERVAL.getValue();
    private Semaphore retrySemaphore = null;
    private TransportClient transportClient;
    private RemoteTransportCollection transports;
    private int maxRetryTimes = 3;
    private boolean startFlag;
    private RemoteRetryProvider remoteRetryProvider;
    private RetryPolicyProvider retryPolicyProvider;
    private RemoteRetryConfig config;

    public RemoteMessageRetry(RemoteRetryProvider remoteRetryProvider) {
        this.remoteRetryProvider = remoteRetryProvider;
    }

    public void start() {
        this.retrySemaphore = new Semaphore(this.remoteRetryLimitThread);
        this.transportClient = this.remoteRetryProvider.createTransportClient();
        this.transports = new RemoteTransportCollection(BalanceType.ROLL, this.transportClient, this.remoteRetryUpdateInterval);
        this.startFlag = true;
        logger.info("remote retry manager is started");
    }

    public boolean isStarted() {
        return this.startFlag;
    }

    public void stop() {
        this.transports.stop();
        this.startFlag = false;
        logger.info("remote retry manager is stopped");
    }

    protected void checkStarted() throws JoyQueueException {
        if (!this.isStarted()) {
            throw new JoyQueueException(JoyQueueCode.CN_SERVICE_NOT_AVAILABLE, new Object[0]);
        }
    }

    public void setRetryPolicyProvider(RetryPolicyProvider retryPolicyProvider) {
        this.retryPolicyProvider = retryPolicyProvider;
    }

    public void addRetry(List<RetryMessageModel> retryMessageModelList) throws JoyQueueException {
        if (CollectionUtils.isEmpty(retryMessageModelList)) {
            return;
        }
        this.checkStarted();
        PutRetry putRetryPayload = new PutRetry(retryMessageModelList);
        Command putRetryCommand = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 6), (Object)putRetryPayload);
        Command sync = this.sync(putRetryCommand);
        if (sync.getHeader().getStatus() != JoyQueueCode.SUCCESS.getCode()) {
            throw new JoyQueueException(JoyQueueCode.RETRY_ADD, new Object[]{""});
        }
    }

    public void retrySuccess(String topic, String app, Long[] messageIds) throws JoyQueueException {
        this.checkStarted();
        this.remoteUpdateRetry(topic, app, messageIds, UpdateRetry.SUCCESS);
    }

    public void retryError(String topic, String app, Long[] messageIds) throws JoyQueueException {
        this.checkStarted();
        this.remoteUpdateRetry(topic, app, messageIds, UpdateRetry.FAILED);
    }

    public void retryExpire(String topic, String app, Long[] messageIds) throws JoyQueueException {
        this.checkStarted();
        this.remoteUpdateRetry(topic, app, messageIds, UpdateRetry.EXPIRED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<RetryMessageModel> getRetry(String topic, String app, short count, long startIndex) throws JoyQueueException {
        this.checkStarted();
        Semaphore semaphore = this.retrySemaphore;
        if (semaphore.tryAcquire()) {
            try {
                GetRetryAck ackPayload;
                List<RetryMessageModel> messageList;
                if (topic == null || topic.trim().isEmpty() || app == null || app.trim().isEmpty() || count <= 0) {
                    ArrayList<RetryMessageModel> arrayList = new ArrayList<RetryMessageModel>();
                    return arrayList;
                }
                GetRetry payload = new GetRetry().topic(topic).app(app).count(count).startId(startIndex);
                Command getRetryCommand = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 7), (Object)payload);
                Command ack = this.sync(getRetryCommand);
                if (ack.getHeader().getStatus() != JoyQueueCode.SUCCESS.getCode()) {
                    throw new JoyQueueException(JoyQueueCode.RETRY_GET, new Object[]{""});
                }
                if (ack == null || (messageList = (ackPayload = (GetRetryAck)((Object)ack.getPayload())).getMessages()) == null || messageList.size() <= 0) return new ArrayList<RetryMessageModel>();
                List<RetryMessageModel> list = messageList;
                return list;
            }
            catch (Exception e) {
                logger.error("getRetry exception, topic: {}, app: {}, index: {}, count: {}", new Object[]{topic, app, startIndex, count, e});
                return new ArrayList<RetryMessageModel>();
            }
            finally {
                if (semaphore != null) {
                    semaphore.release();
                }
            }
        } else {
            if (!logger.isDebugEnabled()) return new ArrayList<RetryMessageModel>();
            logger.debug("tryAcquire failure:" + semaphore.drainPermits());
        }
        return new ArrayList<RetryMessageModel>();
    }

    public int countRetry(String topic, String app) throws JoyQueueException {
        this.checkStarted();
        try {
            if (topic == null || topic.trim().isEmpty() || app == null || app.trim().isEmpty()) {
                return 0;
            }
            GetRetryCount getRetryCountPayload = new GetRetryCount().topic(topic).app(app);
            Command getRetryCountCommand = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 9), (Object)getRetryCountPayload);
            Command ack = this.sync(getRetryCountCommand);
            if (ack.getHeader().getStatus() != JoyQueueCode.SUCCESS.getCode()) {
                logger.error("countRetry exception, topic: {}, app: {}, code: {}", new Object[]{topic, app, ack.getHeader().getStatus()});
                return 0;
            }
            GetRetryCountAck payload = (GetRetryCountAck)((Object)ack.getPayload());
            return payload != null ? payload.getCount() : 0;
        }
        catch (Exception e) {
            logger.error("countRetry exception, topic: {}, app: {}", new Object[]{topic, app, e});
            return 0;
        }
    }

    protected void remoteUpdateRetry(String topic, String app, Long[] messages, byte type) throws JoyQueueException {
        JoyQueueHeader header = new JoyQueueHeader(Direction.REQUEST, 8);
        UpdateRetry updateRetryPayload = new UpdateRetry().topic(topic).app(app).messages(messages).updateType(type);
        Command updateRetryCommand = new Command((Header)header, (Object)updateRetryPayload);
        Command sync = this.sync(updateRetryCommand);
        if (sync.getHeader().getStatus() != JoyQueueCode.SUCCESS.getCode()) {
            throw new JoyQueueException(JoyQueueCode.RETRY_UPDATE, new Object[]{""});
        }
    }

    protected Command sync(Command request) throws JoyQueueException {
        Transport transport = this.transports.get();
        return transport.sync(request, (long)this.config.getTransportTimeout());
    }

    public void setSupplier(PropertySupplier supplier) {
        this.propertySupplier = supplier;
        this.config = new RemoteRetryConfig(supplier);
        this.remoteRetryLimitThread = this.config.getLimitThreads();
        this.remoteRetryUpdateInterval = this.config.getUpdateInterval();
    }

    class RemoteTransportCollection {
        private BalanceType balanceType;
        private TransportClient nettyClient;
        private Map<String, Transport> urlTransportMap = new HashMap<String, Transport>();
        private CopyOnWriteArrayList<Transport> transportList = new CopyOnWriteArrayList();
        private AtomicInteger rollCounter = new AtomicInteger(0);
        private Random random = new Random();
        private final LoopThread updateThread;

        RemoteTransportCollection(BalanceType balanceType, TransportClient nettyClient, long updateInterval) {
            this.balanceType = balanceType;
            this.nettyClient = nettyClient;
            this.buildRemoteTransport();
            this.updateThread = LoopThread.builder().sleepTime(updateInterval, updateInterval).name("Update-Remote-Transport-Thread").onException(e -> logger.error(e.getMessage(), e)).doWork(this::buildRemoteTransport).build();
            this.updateThread.start();
        }

        private void buildRemoteTransport() {
            logger.info("try to build remote transport.");
            Set<String> remoteUrls = this.getRemoteUrl();
            if (CollectionUtils.isEmpty(remoteUrls)) {
                logger.error("Remote retry url set is empty.");
                return;
            }
            this.removeInvalid(remoteUrls);
            this.addRemoteTransport(remoteUrls);
            logger.info("finish build remote transport.");
        }

        private void addRemoteTransport(Set<String> urls) {
            if (CollectionUtils.isNotEmpty(urls)) {
                urls.stream().forEach(url -> {
                    try {
                        if (!this.urlTransportMap.containsKey(url)) {
                            Transport transport = this.nettyClient.createTransport(url);
                            this.urlTransportMap.put((String)url, transport);
                            this.transportList.add(transport);
                            logger.info("add transport by url:[{}]", url);
                        }
                    }
                    catch (Exception e) {
                        logger.error("create retry remote transport error." + e);
                    }
                });
            }
        }

        private Set<String> getRemoteUrl() {
            return RemoteMessageRetry.this.remoteRetryProvider.getUrls();
        }

        public Transport get() throws JoyQueueException {
            if (this.transportList.size() == 0) {
                throw new JoyQueueException("Have no transport error.", JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
            }
            if (this.balanceType == BalanceType.ROLL) {
                int index = this.rollCounter.getAndIncrement();
                if (index < this.transportList.size()) {
                    return this.transportList.get(index);
                }
                if (this.rollCounter.compareAndSet(index + 1, 0)) {
                    return this.transportList.get(0);
                }
                return this.get();
            }
            int index = this.random.nextInt(this.transportList.size());
            return this.transportList.get(index);
        }

        public synchronized void removeInvalid(Set<String> urlSet) {
            Set<String> urls = this.urlTransportMap.keySet();
            if (CollectionUtils.isNotEmpty(urls)) {
                for (String url : urls) {
                    if (urlSet.contains(url)) continue;
                    Transport remove = this.urlTransportMap.remove(url);
                    this.transportList.remove(remove);
                    logger.info("remove remote retry transport by url:[{}]", (Object)url);
                }
            }
        }

        public void stop() {
            this.transportList.stream().forEach(transport -> transport.stop());
        }
    }

    static enum BalanceType {
        ROLL,
        Random;

    }
}

