/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.server.retry.remote.command.codec;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.server.retry.remote.command.GetRetryAck;
import org.joyqueue.server.retry.util.RetrySerializerUtil;

public class GetRetryAckCodec
implements PayloadCodec<JoyQueueHeader, GetRetryAck>,
Type {
    public Object decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        GetRetryAck getRetryAckPayload = new GetRetryAck();
        int count = buffer.readShort();
        ArrayList<RetryMessageModel> list = new ArrayList<RetryMessageModel>(count);
        for (int i = 0; i < count; ++i) {
            RetryMessageModel retryMessageModel = RetrySerializerUtil.deserialize((ByteBuf)buffer);
            list.add(retryMessageModel);
        }
        getRetryAckPayload.setMessages(list);
        return getRetryAckPayload;
    }

    public void encode(GetRetryAck payload, ByteBuf buffer) throws Exception {
        List<RetryMessageModel> messages = payload.getMessages();
        if (messages == null) {
            buffer.writeShort(0);
            return;
        }
        int size = messages.size();
        buffer.writeShort(size);
        for (RetryMessageModel message : messages) {
            ByteBuffer srcBuffer = RetrySerializerUtil.serialize((RetryMessageModel)message);
            buffer.writeBytes(srcBuffer);
        }
    }

    public int type() {
        return -7;
    }
}

