/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.server.retry.remote.command.codec;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.server.retry.remote.command.PutRetry;
import org.joyqueue.server.retry.util.RetrySerializerUtil;

public class PutRetryCodec
implements PayloadCodec<JoyQueueHeader, PutRetry>,
Type {
    public Object decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        int count = buffer.readShort();
        ArrayList<RetryMessageModel> messageList = new ArrayList<RetryMessageModel>(count);
        for (int i = 0; i < count; ++i) {
            RetryMessageModel retryMessageModel = RetrySerializerUtil.deserialize((ByteBuf)buffer);
            messageList.add(retryMessageModel);
        }
        PutRetry putRetry = new PutRetry(messageList);
        return putRetry;
    }

    public void encode(PutRetry payload, ByteBuf buffer) throws Exception {
        List<RetryMessageModel> messageList = payload.getMessages();
        if (messageList == null) {
            buffer.writeShort(0);
            return;
        }
        int size = messageList.size();
        buffer.writeShort(size);
        for (RetryMessageModel message : messageList) {
            ByteBuffer srcBuffer = RetrySerializerUtil.serialize((RetryMessageModel)message);
            buffer.writeBytes(srcBuffer);
        }
    }

    public int type() {
        return 6;
    }
}

