/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.server.retry.remote.handler;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.provider.ExecutorServiceProvider;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.server.retry.remote.command.GetRetry;
import org.joyqueue.server.retry.remote.command.GetRetryAck;
import org.joyqueue.server.retry.remote.command.GetRetryCount;
import org.joyqueue.server.retry.remote.command.GetRetryCountAck;
import org.joyqueue.server.retry.remote.command.PutRetry;
import org.joyqueue.server.retry.remote.command.UpdateRetry;
import org.joyqueue.server.retry.remote.config.RemoteRetryConfigKey;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRetryMessageHandler
implements CommandHandler,
ExecutorServiceProvider {
    protected static final Logger logger = LoggerFactory.getLogger(RemoteRetryMessageHandler.class);
    private MessageRetry messageRetry;
    private PropertySupplier propertySupplier;
    private ExecutorService threadPool;

    public RemoteRetryMessageHandler(MessageRetry messageRetry, PropertySupplier propertySupplier) {
        this.messageRetry = messageRetry;
        this.propertySupplier = propertySupplier;
        this.threadPool = new ThreadPoolExecutor((int)((Integer)propertySupplier.getValue((PropertyDef)RemoteRetryConfigKey.REMOTE_RETRY_THREADS)), (int)((Integer)propertySupplier.getValue((PropertyDef)RemoteRetryConfigKey.REMOTE_RETRY_THREADS)), (long)((Integer)propertySupplier.getValue((PropertyDef)RemoteRetryConfigKey.REMOTE_RETRY_THREAD_KEEPALIVE)).intValue(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>((Integer)propertySupplier.getValue((PropertyDef)RemoteRetryConfigKey.REMOTE_RETRY_THREAD_QUEUE_SIZE)), (ThreadFactory)new NamedThreadFactory("joyqueue-retry-remote-threads"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command handle(Transport transport, Command command) throws TransportException {
        logger.debug("Receive command:[{}]", (Object)command);
        long startTime = SystemClock.now();
        try {
            switch (command.getHeader().getType()) {
                case 6: {
                    Command command2 = this.execute((PutRetry)((Object)command.getPayload()));
                    return command2;
                }
                case 7: {
                    Command command3 = this.execute((GetRetry)((Object)command.getPayload()));
                    return command3;
                }
                case 8: {
                    Command command4 = this.execute((UpdateRetry)((Object)command.getPayload()));
                    return command4;
                }
                case 9: {
                    Command command5 = this.execute((GetRetryCount)((Object)command.getPayload()));
                    return command5;
                }
            }
            try {
                throw new JoyQueueException(JoyQueueCode.CN_COMMAND_UNSUPPORTED.getMessage(new Object[]{command.getHeader().getType()}), JoyQueueCode.CN_COMMAND_UNSUPPORTED.getCode());
            }
            catch (JoyQueueException e) {
                logger.error("Message retry exception, transport: {}", (Object)transport, (Object)e);
                Command command6 = BooleanAck.build((int)e.getCode(), (String)e.getMessage());
                return command6;
            }
            catch (Exception e) {
                logger.error("Message retry exception, transport: {}", (Object)transport, (Object)e);
                Command command7 = BooleanAck.build((int)JoyQueueCode.CN_UNKNOWN_ERROR.getCode(), (String)JoyQueueCode.CN_UNKNOWN_ERROR.getMessage(new Object[0]));
                return command7;
            }
        }
        finally {
            long endTime = SystemClock.now();
            if (endTime - startTime > 100L) {
                logger.info("handle retry more than 100ms, Command:[{}]", (Object)command);
            }
        }
    }

    public ExecutorService getExecutorService(Transport transport, Command command) {
        return this.threadPool;
    }

    private Command execute(PutRetry putRetry) throws JoyQueueException {
        logger.debug("add retry message:[{}]", (Object)putRetry);
        List<RetryMessageModel> messages = putRetry.getMessages();
        this.messageRetry.addRetry(messages);
        return BooleanAck.build();
    }

    private Command execute(GetRetry getRetry) throws JoyQueueException {
        logger.debug("get retry message by condition:[{}]", (Object)getRetry);
        List retryMessageModelList = this.messageRetry.getRetry(getRetry.getTopic(), getRetry.getApp(), getRetry.getCount(), getRetry.getStartId());
        GetRetryAck payload = new GetRetryAck();
        payload.setMessages(retryMessageModelList);
        Command command = new Command();
        command.setHeader((Header)new JoyQueueHeader(Direction.RESPONSE, -7));
        command.setPayload((Object)payload);
        return command;
    }

    private Command execute(UpdateRetry updateRetry) throws JoyQueueException {
        logger.debug("update retry by condition:[{}]", (Object)updateRetry);
        int updateType = updateRetry.getUpdateType();
        if (UpdateRetry.SUCCESS == updateType) {
            this.messageRetry.retrySuccess(updateRetry.getTopic(), updateRetry.getApp(), (Object[])updateRetry.getMessages());
        } else if (UpdateRetry.FAILED == updateType) {
            this.messageRetry.retryError(updateRetry.getTopic(), updateRetry.getApp(), (Object[])updateRetry.getMessages());
        } else if (UpdateRetry.EXPIRED == updateType) {
            this.messageRetry.retryExpire(updateRetry.getTopic(), updateRetry.getApp(), (Object[])updateRetry.getMessages());
        }
        return BooleanAck.build();
    }

    private Command execute(GetRetryCount getRetryCount) throws JoyQueueException {
        logger.debug("get retry count by condition:[{}]", (Object)getRetryCount);
        int retryCount = this.messageRetry.countRetry(getRetryCount.getTopic(), getRetryCount.getApp());
        GetRetryCountAck getRetryCountAckPayload = new GetRetryCountAck();
        getRetryCountAckPayload.setTopic(getRetryCount.getTopic());
        getRetryCountAckPayload.setApp(getRetryCountAckPayload.getApp());
        getRetryCountAckPayload.setCount(retryCount);
        Command command = new Command();
        command.setHeader((Header)new JoyQueueHeader(Direction.RESPONSE, -9));
        command.setPayload((Object)getRetryCountAckPayload);
        return command;
    }
}

