/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue;

import io.openmessaging.KeyValue;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.consumer.Consumer;
import io.openmessaging.exception.OMSUnsupportException;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.config.KeyValueConverter;
import io.openmessaging.joyqueue.consumer.support.ConsumerImpl;
import io.openmessaging.joyqueue.producer.extension.ExtensionMessageFactory;
import io.openmessaging.joyqueue.producer.message.ExtensionMessageFactoryImpl;
import io.openmessaging.joyqueue.producer.support.ProducerImpl;
import io.openmessaging.joyqueue.producer.support.TransactionProducerImpl;
import io.openmessaging.joyqueue.support.ConsumerWrapper;
import io.openmessaging.joyqueue.support.MessageAccessPointHolder;
import io.openmessaging.joyqueue.support.ProducerWrapper;
import io.openmessaging.manager.ResourceManager;
import io.openmessaging.message.MessageFactory;
import io.openmessaging.producer.Producer;
import io.openmessaging.producer.TransactionStateCheckListener;
import org.joyqueue.client.internal.MessageAccessPoint;
import org.joyqueue.client.internal.MessageAccessPointFactory;
import org.joyqueue.client.internal.consumer.MessageConsumer;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingAccessPointImpl
implements MessagingAccessPoint {
    protected final Logger logger = LoggerFactory.getLogger(MessagingAccessPointImpl.class);
    private KeyValue attributes;
    private NameServerConfig nameServerConfig;
    private TransportConfig transportConfig;
    private ProducerConfig producerConfig;
    private ConsumerConfig consumerConfig;
    private TxFeedbackConfig txFeedbackConfig;
    private ExtensionMessageFactory extensionMessageFactory;
    private MessageAccessPointHolder messageAccessPointHolder;

    public MessagingAccessPointImpl(KeyValue attributes) {
        this.attributes = attributes;
        this.nameServerConfig = KeyValueConverter.convertNameServerConfig(attributes);
        this.transportConfig = KeyValueConverter.convertTransportConfig(attributes);
        this.producerConfig = KeyValueConverter.convertProducerConfig(this.nameServerConfig, attributes);
        this.consumerConfig = KeyValueConverter.convertConsumerConfig(this.nameServerConfig, attributes);
        this.txFeedbackConfig = KeyValueConverter.convertFeedbackConfig(this.nameServerConfig, attributes);
        this.extensionMessageFactory = this.createMessageFactory();
    }

    protected ExtensionMessageFactory createMessageFactory() {
        return new ExtensionMessageFactoryImpl();
    }

    public synchronized Producer createProducer() {
        MessageAccessPointHolder messageAccessPointHolder = this.getOrCreateMessageAccessPointHolder();
        MessageAccessPoint messageAccessPoint = messageAccessPointHolder.getMessageAccessPoint();
        MessageProducer messageProducer = messageAccessPoint.createProducer(this.producerConfig);
        ProducerImpl producer = new ProducerImpl(messageProducer, this.extensionMessageFactory);
        return new ProducerWrapper(producer, messageAccessPointHolder);
    }

    public synchronized Producer createProducer(TransactionStateCheckListener transactionStateCheckListener) {
        MessageAccessPointHolder messageAccessPointHolder = this.getOrCreateMessageAccessPointHolder();
        MessageAccessPoint messageAccessPoint = messageAccessPointHolder.getMessageAccessPoint();
        MessageProducer messageProducer = messageAccessPoint.createProducer(this.producerConfig);
        ProducerImpl producer = new ProducerImpl(messageProducer, this.extensionMessageFactory);
        TransactionProducerImpl transactionProducer = new TransactionProducerImpl(producer, transactionStateCheckListener, messageProducer, messageAccessPoint, this.txFeedbackConfig);
        return new ProducerWrapper(transactionProducer, messageAccessPointHolder);
    }

    public synchronized Consumer createConsumer() {
        MessageAccessPointHolder messageAccessPointHolder = this.getOrCreateMessageAccessPointHolder();
        MessageAccessPoint messageAccessPoint = messageAccessPointHolder.getMessageAccessPoint();
        MessageConsumer messageConsumer = messageAccessPoint.createConsumer(this.consumerConfig);
        ConsumerImpl consumer = new ConsumerImpl(messageConsumer);
        return new ConsumerWrapper(consumer, messageAccessPointHolder);
    }

    protected MessageAccessPointHolder getOrCreateMessageAccessPointHolder() {
        if (this.messageAccessPointHolder != null && this.messageAccessPointHolder.getMessageAccessPoint().isStarted()) {
            return this.messageAccessPointHolder;
        }
        try {
            MessageAccessPoint messageAccessPoint = MessageAccessPointFactory.create(this.nameServerConfig, this.transportConfig);
            messageAccessPoint.start();
            this.messageAccessPointHolder = new MessageAccessPointHolder(messageAccessPoint);
        }
        catch (Exception e) {
            this.logger.error("create messagingAccessPoint exception", (Throwable)e);
            throw ExceptionConverter.convertRuntimeException(e);
        }
        return this.messageAccessPointHolder;
    }

    public ResourceManager resourceManager() {
        throw new OMSUnsupportException(JoyQueueCode.CN_COMMAND_UNSUPPORTED.getCode(), "resourceManager is not supported");
    }

    public MessageFactory messageFactory() {
        return this.extensionMessageFactory;
    }

    public KeyValue attributes() {
        return this.attributes;
    }

    public String version() {
        return "1.0.0-alpha";
    }
}

