/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.config;

import io.openmessaging.exception.OMSDestinationException;
import io.openmessaging.exception.OMSMessageFormatException;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.exception.OMSSecurityException;
import io.openmessaging.exception.OMSTimeOutException;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.transport.exception.TransportException;

public class ExceptionConverter {
    public static OMSRuntimeException convertRuntimeException(Throwable cause) {
        if (cause instanceof OMSRuntimeException) {
            return (OMSRuntimeException)cause;
        }
        if (cause instanceof IllegalArgumentException) {
            return new OMSRuntimeException(JoyQueueCode.CN_PARAM_ERROR.getCode(), cause.getMessage(), cause);
        }
        if (cause instanceof ClientException) {
            ClientException clientException = (ClientException)cause;
            if (clientException.getCause() instanceof TransportException.RequestTimeoutException) {
                return new OMSTimeOutException(JoyQueueCode.CN_REQUEST_TIMEOUT.getCode(), clientException.getMessage(), cause);
            }
            JoyQueueCode joyQueueCode = JoyQueueCode.valueOf((int)clientException.getCode());
            if (joyQueueCode.equals((Object)JoyQueueCode.FW_TOPIC_NOT_EXIST) || joyQueueCode.equals((Object)JoyQueueCode.FW_PRODUCER_NOT_EXISTS)) {
                return new OMSSecurityException(joyQueueCode.getCode(), clientException.getMessage(), cause);
            }
            return new OMSRuntimeException(((ClientException)cause).getCode(), cause.getMessage(), cause);
        }
        return new OMSRuntimeException(JoyQueueCode.CN_UNKNOWN_ERROR.getCode(), JoyQueueCode.CN_UNKNOWN_ERROR.getMessage(new Object[0]), cause);
    }

    public static OMSRuntimeException convertProduceException(Throwable cause) {
        if (cause instanceof ClientException) {
            ClientException clientException = (ClientException)cause;
            if (clientException.getCause() instanceof TransportException.RequestTimeoutException) {
                return new OMSTimeOutException(JoyQueueCode.CN_REQUEST_TIMEOUT.getCode(), clientException.getMessage(), cause);
            }
            JoyQueueCode joyQueueCode = JoyQueueCode.valueOf((int)clientException.getCode());
            if (joyQueueCode.equals((Object)JoyQueueCode.FW_TOPIC_NOT_EXIST) || joyQueueCode.equals((Object)JoyQueueCode.FW_PRODUCER_NOT_EXISTS)) {
                return new OMSSecurityException(joyQueueCode.getCode(), clientException.getMessage(), cause);
            }
            if (joyQueueCode.equals((Object)JoyQueueCode.CN_PARAM_ERROR)) {
                return new OMSMessageFormatException(joyQueueCode.getCode(), clientException.getMessage(), cause);
            }
            if (joyQueueCode.equals((Object)JoyQueueCode.CN_SERVICE_NOT_AVAILABLE)) {
                return new OMSDestinationException(joyQueueCode.getCode(), clientException.getMessage(), cause);
            }
            return new OMSRuntimeException(clientException.getCode(), clientException.getMessage(), cause);
        }
        return ExceptionConverter.convertRuntimeException(cause);
    }

    public static OMSRuntimeException convertConsumeException(Throwable cause) {
        if (cause instanceof ClientException) {
            ClientException clientException = (ClientException)cause;
            if (clientException.getCause() instanceof TransportException.RequestTimeoutException) {
                return new OMSTimeOutException(JoyQueueCode.CN_REQUEST_TIMEOUT.getCode(), clientException.getMessage(), cause);
            }
            JoyQueueCode joyQueueCode = JoyQueueCode.valueOf((int)clientException.getCode());
            if (joyQueueCode.equals((Object)JoyQueueCode.FW_TOPIC_NOT_EXIST) || joyQueueCode.equals((Object)JoyQueueCode.FW_CONSUMER_NOT_EXISTS)) {
                return new OMSSecurityException(joyQueueCode.getCode(), clientException.getMessage(), cause);
            }
            if (joyQueueCode.equals((Object)JoyQueueCode.CN_SERVICE_NOT_AVAILABLE)) {
                return new OMSDestinationException(joyQueueCode.getCode(), clientException.getMessage(), cause);
            }
            return new OMSRuntimeException(((ClientException)cause).getCode(), cause.getMessage(), cause);
        }
        return ExceptionConverter.convertRuntimeException(cause);
    }
}

