/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.config;

import io.openmessaging.KeyValue;
import io.openmessaging.joyqueue.config.KeyValueHelper;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.domain.QosLevel;

public class KeyValueConverter {
    public static NameServerConfig convertNameServerConfig(KeyValue attributes) {
        NameServerConfig nameServerConfig = new NameServerConfig();
        nameServerConfig.setAddress(attributes.getString("ACCESS_POINTS"));
        nameServerConfig.setApp(attributes.getString("ACCOUNT_ID"));
        nameServerConfig.setToken(attributes.getString("ACCOUNT_KEY"));
        nameServerConfig.setRegion(attributes.getString("REGION"));
        nameServerConfig.setNamespace(attributes.getString("NAMESERVER_NAMESPACE"));
        nameServerConfig.setUpdateMetadataInterval(KeyValueHelper.getInt(attributes, "NAMESERVER_METADATA_UPDATE_INTERVAL", nameServerConfig.getUpdateMetadataInterval()));
        nameServerConfig.setTempMetadataInterval(KeyValueHelper.getInt(attributes, "NAMESERVER_METADATA_TEMP_INTERVAL", nameServerConfig.getTempMetadataInterval()));
        nameServerConfig.setUpdateMetadataThread(KeyValueHelper.getInt(attributes, "NAMESERVER_METADATA_UPDATE_THREAD", nameServerConfig.getUpdateMetadataThread()));
        nameServerConfig.setUpdateMetadataQueueSize(KeyValueHelper.getInt(attributes, "NAMESERVER_METADATA_UPDATE_QUEUE_SIZE", nameServerConfig.getUpdateMetadataQueueSize()));
        return nameServerConfig;
    }

    public static TransportConfig convertTransportConfig(KeyValue attributes) {
        TransportConfig transportConfig = new TransportConfig();
        transportConfig.setConnections(KeyValueHelper.getInt(attributes, "TRANSPORT_CONNECTIONS", transportConfig.getConnections()));
        transportConfig.setSoTimeout(KeyValueHelper.getInt(attributes, "TRANSPORT_SO_TIMEOUT", transportConfig.getSoTimeout()));
        transportConfig.setIoThreads(KeyValueHelper.getInt(attributes, "TRANSPORT_IO_THREADS", transportConfig.getIoThreads()));
        transportConfig.setCallbackThreads(KeyValueHelper.getInt(attributes, "TRANSPORT_CALLBACK_THREADS", transportConfig.getCallbackThreads()));
        transportConfig.setChannelMaxIdleTime(KeyValueHelper.getInt(attributes, "TRANSPORT_CHANNEL_MAX_IDLE_TIME", transportConfig.getChannelMaxIdleTime()));
        transportConfig.setHeartbeatInterval(KeyValueHelper.getInt(attributes, "TRANSPORT_HEARTBEAT_INTERVAL", transportConfig.getHeartbeatInterval()));
        transportConfig.setHeartbeatTimeout(KeyValueHelper.getInt(attributes, "TRANSPORT_HEARTBEAT_TIMEOUT", transportConfig.getHeartbeatTimeout()));
        transportConfig.setSoLinger(KeyValueHelper.getInt(attributes, "TRANSPORT_SO_LINGER", transportConfig.getSoLinger()));
        transportConfig.setTcpNoDelay(attributes.getBoolean("TRANSPORT_CONNECTIONS", transportConfig.isTcpNoDelay()));
        transportConfig.setKeepAlive(attributes.getBoolean("TRANSPORT_KEEPALIVE", transportConfig.isKeepAlive()));
        transportConfig.setSoTimeout(KeyValueHelper.getInt(attributes, "TRANSPORT_SO_TIMEOUT", transportConfig.getSoTimeout()));
        transportConfig.setSocketBufferSize(KeyValueHelper.getInt(attributes, "TRANSPORT_SOCKET_BUFFER_SIZE", transportConfig.getSocketBufferSize()));
        transportConfig.setMaxOneway(KeyValueHelper.getInt(attributes, "TRANSPORT_MAX_ONEWAY", transportConfig.getMaxOneway()));
        transportConfig.setMaxAsync(KeyValueHelper.getInt(attributes, "TRANSPORT_MAX_ASYNC", transportConfig.getMaxAsync()));
        transportConfig.setNonBlockOneway(attributes.getBoolean("TRANSPORT_NONBLOCK_ONEWAY", transportConfig.isNonBlockOneway()));
        transportConfig.getRetryPolicy().setMaxRetrys(Integer.valueOf(KeyValueHelper.getInt(attributes, "TRANSPORT_RETRIES", transportConfig.getRetryPolicy().getMaxRetrys())));
        return transportConfig;
    }

    public static ProducerConfig convertProducerConfig(KeyValue attributes) {
        ProducerConfig producerConfig = new ProducerConfig();
        producerConfig.setTimeout(attributes.getLong("PRODUCER_TIMEOUT", producerConfig.getTimeout()));
        producerConfig.setProduceTimeout(attributes.getLong("PRODUCER_PRODUCE_TIMEOUT", producerConfig.getProduceTimeout()));
        producerConfig.setTransactionTimeout(attributes.getLong("PRODUCER_TRANSACTION_TIMEOUT", producerConfig.getTransactionTimeout()));
        producerConfig.setFailover(attributes.getBoolean("PRODUCER_FAILOVER", producerConfig.isFailover()));
        producerConfig.getRetryPolicy().setMaxRetrys(Integer.valueOf(KeyValueHelper.getInt(attributes, "PRODUCER_RETRIES", producerConfig.getRetryPolicy().getMaxRetrys())));
        producerConfig.setQosLevel(QosLevel.valueOf((int)KeyValueHelper.getInt(attributes, "PRODUCER_QOSLEVEL", producerConfig.getQosLevel().value())));
        producerConfig.setCompress(attributes.getBoolean("PRODUCER_COMPRESS", producerConfig.isCompress()));
        producerConfig.setCompressType(KeyValueHelper.getString(attributes, "PRODUCER_COMPRESS_TYPE", producerConfig.getCompressType()));
        producerConfig.setCompressThreshold(KeyValueHelper.getInt(attributes, "PRODUCER_COMPRESS_THRESHOLD", producerConfig.getCompressThreshold()));
        producerConfig.setBatch(attributes.getBoolean("PRODUCER_BATCH", producerConfig.isBatch()));
        producerConfig.setSelectorType(KeyValueHelper.getString(attributes, "PRODUCER_SELECTOR_TYPE", producerConfig.getSelectorType()));
        producerConfig.setBusinessIdLengthLimit(KeyValueHelper.getInt(attributes, "PRODUCER_BUSINESSID_LENGTH_LIMIT", producerConfig.getBusinessIdLengthLimit()));
        producerConfig.setBodyLengthLimit(KeyValueHelper.getInt(attributes, "PRODUCER_BODY_LENGTH_LIMIT", producerConfig.getBodyLengthLimit()));
        producerConfig.setBatchBodyLengthLimit(KeyValueHelper.getInt(attributes, "PRODUCER_BATCH_BODY_LENGTH_LIMIT", producerConfig.getBatchBodyLengthLimit()));
        return producerConfig;
    }

    public static ProducerConfig convertProducerConfig(NameServerConfig nameServerConfig, KeyValue attributes) {
        ProducerConfig producerConfig = KeyValueConverter.convertProducerConfig(attributes);
        producerConfig.setApp(nameServerConfig.getApp());
        return producerConfig;
    }

    public static ConsumerConfig convertConsumerConfig(KeyValue attributes) {
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setGroup(KeyValueHelper.getString(attributes, "CONSUMER_GROUP", consumerConfig.getGroup()));
        consumerConfig.setBatchSize(KeyValueHelper.getInt(attributes, "CONSUMER_BATCH_SIZE", consumerConfig.getBatchSize()));
        consumerConfig.setAckTimeout(attributes.getLong("CONSUMER_ACK_TIMEOUT", consumerConfig.getAckTimeout()));
        consumerConfig.setTimeout(attributes.getLong("CONSUMER_TIMEOUT", consumerConfig.getTimeout()));
        consumerConfig.setPollTimeout(attributes.getLong("CONSUMER_POLL_TIMEOUT", consumerConfig.getPollTimeout()));
        consumerConfig.setLongPollTimeout(attributes.getLong("CONSUMER_LONGPOLL_TIMEOUT", consumerConfig.getLongPollTimeout()));
        consumerConfig.setInterval(attributes.getLong("CONSUMER_INTERVAL", consumerConfig.getInterval()));
        consumerConfig.setIdleInterval(attributes.getLong("CONSUMER_IDLE_INTERVAL", consumerConfig.getIdleInterval()));
        consumerConfig.setSessionTimeout(attributes.getLong("CONSUMER_SESSION_TIMEOUT", consumerConfig.getSessionTimeout()));
        consumerConfig.setThread(KeyValueHelper.getInt(attributes, "CONSUMER_THREAD", consumerConfig.getThread()));
        consumerConfig.setFailover(attributes.getBoolean("CONSUMER_FAILOVER", consumerConfig.isFailover()));
        consumerConfig.setLoadBalance(attributes.getBoolean("CONSUMER_LOADBALANCE", consumerConfig.isLoadBalance()));
        consumerConfig.setLoadBalanceType(KeyValueHelper.getString(attributes, "CONSUMER_LOADBALANCE_TYPE", consumerConfig.getLoadBalanceType()));
        consumerConfig.setBroadcastGroup(KeyValueHelper.getString(attributes, "CONSUMER_BROADCAST_GROUP", consumerConfig.getBroadcastGroup()));
        consumerConfig.setBroadcastLocalPath(KeyValueHelper.getString(attributes, "CONSUMER_BROADCAST_LOCAL_PATH", consumerConfig.getBroadcastLocalPath()));
        consumerConfig.setBroadcastPersistInterval(KeyValueHelper.getInt(attributes, "CONSUMER_BROADCAST_PERSIST_INTERVAL", consumerConfig.getBroadcastPersistInterval()));
        consumerConfig.setBroadcastIndexExpireTime(KeyValueHelper.getInt(attributes, "CONSUMER_BROADCAST_INDEX_EXPIRE_TIME", consumerConfig.getBroadcastIndexExpireTime()));
        return consumerConfig;
    }

    public static ConsumerConfig convertConsumerConfig(NameServerConfig nameServerConfig, KeyValue attributes) {
        ConsumerConfig consumerConfig = KeyValueConverter.convertConsumerConfig(attributes);
        consumerConfig.setApp(nameServerConfig.getApp());
        return consumerConfig;
    }

    public static TxFeedbackConfig convertFeedbackConfig(KeyValue attributes) {
        TxFeedbackConfig txFeedbackConfig = new TxFeedbackConfig();
        txFeedbackConfig.setTimeout(attributes.getLong("TX_FEEDBACK_TIMEOUT", txFeedbackConfig.getTimeout()));
        txFeedbackConfig.setLongPollTimeout(attributes.getLong("TX_FEEDBACK_LONGPOLL_TIMEOUT", txFeedbackConfig.getLongPollTimeout()));
        txFeedbackConfig.setFetchInterval(KeyValueHelper.getInt(attributes, "TX_FEEDBACK_FETCH_INTERVAL", txFeedbackConfig.getFetchInterval()));
        txFeedbackConfig.setFetchSize(KeyValueHelper.getInt(attributes, "TX_FEEDBACK_FETCH_SIZE", txFeedbackConfig.getFetchSize()));
        return txFeedbackConfig;
    }

    public static TxFeedbackConfig convertFeedbackConfig(NameServerConfig nameServerConfig, KeyValue attributes) {
        TxFeedbackConfig txFeedbackConfig = KeyValueConverter.convertFeedbackConfig(attributes);
        txFeedbackConfig.setApp(nameServerConfig.getApp());
        return txFeedbackConfig;
    }
}

