/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.consumer.interceptor;

import com.google.common.collect.Sets;
import io.openmessaging.KeyValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joyqueue.client.internal.consumer.interceptor.ConsumeContext;

public class ContextAttributeAdapter
implements KeyValue {
    private ConsumeContext context;

    public ContextAttributeAdapter(ConsumeContext context) {
        this.context = context;
    }

    public KeyValue put(String key, boolean value) {
        this.context.putAttribute(key, value);
        return this;
    }

    public KeyValue put(String key, short value) {
        this.context.putAttribute(key, value);
        return this;
    }

    public KeyValue put(String key, int value) {
        this.context.putAttribute(key, value);
        return this;
    }

    public KeyValue put(String key, long value) {
        this.context.putAttribute(key, value);
        return this;
    }

    public KeyValue put(String key, double value) {
        this.context.putAttribute(key, value);
        return this;
    }

    public KeyValue put(String key, String value) {
        this.context.putAttribute(key, value);
        return this;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.context.getAttribute(key);
        return value == null ? defaultValue : Boolean.valueOf(String.valueOf(value));
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        Object value = this.context.getAttribute(key);
        return value == null ? defaultValue : Short.valueOf(String.valueOf(value));
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.context.getAttribute(key);
        return value == null ? 0 : Integer.valueOf(String.valueOf(value));
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Object value = this.context.getAttribute(key);
        return value == null ? 0L : Long.valueOf(String.valueOf(value));
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Object value = this.context.getAttribute(key);
        return value == null ? defaultValue : Double.valueOf(String.valueOf(value));
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.context.getAttribute(key);
        return value == null ? null : String.valueOf(value);
    }

    public Set<String> keySet() {
        Map<Object, Object> attributes = this.context.getAttributes();
        if (attributes == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            result.add(String.valueOf(entry.getKey()));
        }
        return result;
    }

    public boolean containsKey(String key) {
        return this.context.containsAttribute(key);
    }
}

