/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.consumer.message;

import io.openmessaging.KeyValue;
import io.openmessaging.consumer.MessageReceipt;
import io.openmessaging.extension.ExtensionHeader;
import io.openmessaging.joyqueue.consumer.message.MessageExtensionHeaderAdapter;
import io.openmessaging.joyqueue.consumer.message.MessageHeaderAdapter;
import io.openmessaging.joyqueue.consumer.message.MessagePropertiesAdapter;
import io.openmessaging.joyqueue.consumer.message.MessageReceiptAdapter;
import io.openmessaging.joyqueue.message.ExtensionMessage;
import io.openmessaging.message.Header;
import java.util.Optional;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;

public class MessageAdapter
implements ExtensionMessage {
    private ConsumeMessage message;
    private Header header;
    private Optional<ExtensionHeader> extensionHeader;
    private KeyValue properties;
    private MessageReceipt receipt;

    public MessageAdapter(ConsumeMessage message) {
        this.message = message;
    }

    public Header header() {
        if (this.header == null) {
            this.header = new MessageHeaderAdapter(this.message);
        }
        return this.header;
    }

    public Optional<ExtensionHeader> extensionHeader() {
        if (this.extensionHeader == null) {
            this.extensionHeader = Optional.of(new MessageExtensionHeaderAdapter(this.message));
        }
        return this.extensionHeader;
    }

    public KeyValue properties() {
        if (this.properties == null) {
            this.properties = new MessagePropertiesAdapter(this.message);
        }
        return this.properties;
    }

    public byte[] getData() {
        return this.message.getBodyBytes();
    }

    public void setData(byte[] data) {
    }

    @Override
    public void setStringData(String data) {
    }

    @Override
    public String getStringData() {
        return this.message.getBody();
    }

    public MessageReceipt getMessageReceipt() {
        if (this.receipt == null) {
            this.receipt = new MessageReceiptAdapter(this.message);
        }
        return this.receipt;
    }

    public String toString() {
        return this.message.toString();
    }
}

