/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.consumer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.openmessaging.consumer.BatchMessageListener;
import io.openmessaging.consumer.MessageListener;
import io.openmessaging.consumer.MessageReceipt;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.extension.Extension;
import io.openmessaging.extension.QueueMetaData;
import io.openmessaging.interceptor.ConsumerInterceptor;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.consumer.ConsumerIndex;
import io.openmessaging.joyqueue.consumer.ExtensionConsumer;
import io.openmessaging.joyqueue.consumer.extension.ExtensionAdapter;
import io.openmessaging.joyqueue.consumer.message.MessageConverter;
import io.openmessaging.joyqueue.consumer.message.MessageReceiptAdapter;
import io.openmessaging.joyqueue.consumer.support.BatchMessageListenerAdapter;
import io.openmessaging.joyqueue.consumer.support.ConsumerInterceptorAdapter;
import io.openmessaging.joyqueue.consumer.support.MessageListenerAdapter;
import io.openmessaging.joyqueue.support.AbstractServiceLifecycle;
import io.openmessaging.message.Message;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.consumer.MessageConsumer;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.domain.FetchIndexData;
import org.joyqueue.network.command.RetryType;

public class ConsumerImpl
extends AbstractServiceLifecycle
implements ExtensionConsumer {
    private MessageConsumer messageConsumer;
    private Optional<Extension> extension;

    public ConsumerImpl(MessageConsumer messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    protected void doStart() throws Exception {
        try {
            this.messageConsumer.start();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    protected void doStop() {
        try {
            this.messageConsumer.stop();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void resume() {
        try {
            this.messageConsumer.resumeListen();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void suspend() {
        try {
            this.messageConsumer.suspendListen();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void suspend(long timeout) {
        this.suspend();
    }

    public boolean isSuspended() {
        try {
            return this.messageConsumer.isListenSuspended();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void bindQueue(String queueName) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            this.messageConsumer.subscribe(queueName);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void bindQueue(String queueName, MessageListener listener) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"listener can not be null");
            this.messageConsumer.subscribe(queueName, new MessageListenerAdapter(listener));
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void bindQueue(String queueName, BatchMessageListener listener) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"listener can not be null");
            this.messageConsumer.subscribeBatch(queueName, new BatchMessageListenerAdapter(listener));
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void unbindQueue(String queueName) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            if (!queueName.equals(this.messageConsumer.subscription())) {
                return;
            }
            this.messageConsumer.unsubscribe();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public boolean isBindQueue() {
        try {
            return this.messageConsumer.isSubscribed();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public String getBindQueue() {
        try {
            return this.messageConsumer.subscription();
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void addInterceptor(ConsumerInterceptor interceptor) {
        try {
            Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
            this.messageConsumer.addInterceptor(new ConsumerInterceptorAdapter(interceptor));
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void removeInterceptor(ConsumerInterceptor interceptor) {
        try {
            Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
            this.messageConsumer.removeInterceptor(new ConsumerInterceptorAdapter(interceptor));
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public Message receive(long timeout) {
        try {
            ConsumeMessage consumeMessage = this.messageConsumer.pollOnce(timeout, TimeUnit.MILLISECONDS);
            if (consumeMessage == null) {
                return null;
            }
            return MessageConverter.convertMessage(consumeMessage);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public List<Message> batchReceive(long timeout) {
        try {
            List<ConsumeMessage> consumeMessages = this.messageConsumer.poll(timeout, TimeUnit.MILLISECONDS);
            if (CollectionUtils.isEmpty(consumeMessages)) {
                return Collections.emptyList();
            }
            return MessageConverter.convertMessages(consumeMessages);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    @Override
    public Message receive(short partition, long timeout) {
        try {
            ConsumeMessage consumeMessage = this.messageConsumer.pollPartitionOnce(partition, timeout, TimeUnit.MILLISECONDS);
            if (consumeMessage == null) {
                return null;
            }
            return MessageConverter.convertMessage(consumeMessage);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    @Override
    public List<Message> batchReceive(short partition, long timeout) {
        try {
            List<ConsumeMessage> consumeMessages = this.messageConsumer.pollPartition(partition, timeout, TimeUnit.MILLISECONDS);
            if (CollectionUtils.isEmpty(consumeMessages)) {
                return Collections.emptyList();
            }
            return MessageConverter.convertMessages(consumeMessages);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    @Override
    public Message receive(short partition, long index, long timeout) {
        try {
            ConsumeMessage consumeMessage = this.messageConsumer.pollPartitionOnce(partition, index, timeout, TimeUnit.MILLISECONDS);
            if (consumeMessage == null) {
                return null;
            }
            return MessageConverter.convertMessage(consumeMessage);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    @Override
    public List<Message> batchReceive(short partition, long index, long timeout) {
        try {
            List<ConsumeMessage> consumeMessages = this.messageConsumer.pollPartition(partition, index, timeout, TimeUnit.MILLISECONDS);
            if (CollectionUtils.isEmpty(consumeMessages)) {
                return Collections.emptyList();
            }
            return MessageConverter.convertMessages(consumeMessages);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public void ack(MessageReceipt receipt) {
        try {
            Preconditions.checkArgument((boolean)(receipt instanceof MessageReceiptAdapter), (Object)"receipt is not supported");
            MessageReceiptAdapter messageReceiptAdapter = (MessageReceiptAdapter)receipt;
            ConsumeMessage message = messageReceiptAdapter.getMessage();
            ConsumeReply consumeReply = new ConsumeReply(message.getPartition(), message.getIndex(), RetryType.NONE);
            this.messageConsumer.replyOnce(consumeReply);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    public Optional<Extension> getExtension() {
        if (this.extension == null) {
            this.extension = Optional.of(new ExtensionAdapter(this.messageConsumer));
        }
        return this.extension;
    }

    public QueueMetaData getQueueMetaData(String queueName) {
        return this.getExtension().get().getQueueMetaData(queueName);
    }

    @Override
    public ConsumerIndex getIndex(short partition) {
        FetchIndexData fetchIndexData = this.messageConsumer.fetchIndex(partition);
        return new ConsumerIndex(fetchIndexData.getIndex(), fetchIndexData.getLeftIndex(), fetchIndexData.getRightIndex());
    }

    @Override
    public void batchAck(List<MessageReceipt> receiptList) {
        try {
            LinkedList replyList = Lists.newLinkedList();
            for (MessageReceipt receipt : receiptList) {
                Preconditions.checkArgument((boolean)(receipt instanceof MessageReceiptAdapter), (Object)"receipt is not supported");
                MessageReceiptAdapter messageReceiptAdapter = (MessageReceiptAdapter)receipt;
                ConsumeMessage message = messageReceiptAdapter.getMessage();
                ConsumeReply consumeReply = new ConsumeReply(message.getPartition(), message.getIndex(), RetryType.NONE);
                replyList.add(consumeReply);
            }
            this.messageConsumer.reply(replyList);
        }
        catch (Throwable cause) {
            throw this.handleConsumeException(cause);
        }
    }

    protected OMSRuntimeException handleConsumeException(Throwable cause) {
        throw ExceptionConverter.convertConsumeException(cause);
    }
}

