/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.consumer.support;

import io.openmessaging.interceptor.Context;
import io.openmessaging.joyqueue.consumer.interceptor.ContextAdapter;
import io.openmessaging.joyqueue.consumer.message.MessageConverter;
import io.openmessaging.message.Message;
import java.util.List;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.interceptor.ConsumeContext;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptor;

public class ConsumerInterceptorAdapter
implements ConsumerInterceptor {
    private static final String OMS_CONTEXT_ATTRIBUTE_KEY = "_OMS_CONTEXT_";
    private static final String OMS_MESSAGES_ATTRIBUTE_KEY = "_OMS_MESSAGES_";
    private io.openmessaging.interceptor.ConsumerInterceptor omsConsumerInterceptor;

    public ConsumerInterceptorAdapter(io.openmessaging.interceptor.ConsumerInterceptor omsConsumerInterceptor) {
        this.omsConsumerInterceptor = omsConsumerInterceptor;
    }

    @Override
    public boolean preConsume(ConsumeContext context) {
        Context omsContext = this.getOrCreateOMSContext(context);
        List<Message> omsMessages = this.getOrConvertMessages(context);
        for (Message omsMessage : omsMessages) {
            this.omsConsumerInterceptor.preReceive(omsMessage, omsContext);
        }
        return true;
    }

    @Override
    public void postConsume(ConsumeContext context, List<ConsumeReply> consumeReplies) {
        Context omsContext = this.getOrCreateOMSContext(context);
        List<Message> omsMessages = this.getOrConvertMessages(context);
        for (Message omsMessage : omsMessages) {
            this.omsConsumerInterceptor.postReceive(omsMessage, omsContext);
        }
    }

    protected List<Message> getOrConvertMessages(ConsumeContext context) {
        List<Message> omsMessages = (List<Message>)context.getAttribute(OMS_MESSAGES_ATTRIBUTE_KEY);
        if (omsMessages == null) {
            omsMessages = MessageConverter.convertMessages(context.getMessages());
            context.putAttribute(OMS_MESSAGES_ATTRIBUTE_KEY, omsMessages);
        }
        return omsMessages;
    }

    protected Context getOrCreateOMSContext(ConsumeContext context) {
        Context omsContext = (Context)context.getAttribute(OMS_CONTEXT_ATTRIBUTE_KEY);
        if (omsContext == null) {
            omsContext = new ContextAdapter(context);
            context.putAttribute(OMS_CONTEXT_ATTRIBUTE_KEY, omsContext);
        }
        return omsContext;
    }

    public int hashCode() {
        return this.omsConsumerInterceptor.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerInterceptorAdapter)) {
            return false;
        }
        return this.omsConsumerInterceptor.equals(((ConsumerInterceptorAdapter)obj).getOmsConsumerInterceptor());
    }

    public String toString() {
        return this.omsConsumerInterceptor.toString();
    }

    public io.openmessaging.interceptor.ConsumerInterceptor getOmsConsumerInterceptor() {
        return this.omsConsumerInterceptor;
    }
}

