/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.extension;

import com.google.common.base.Preconditions;
import io.openmessaging.extension.Extension;
import io.openmessaging.extension.QueueMetaData;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.extension.TopicMetadataConverter;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;

public abstract class AbstractExtensionAdapter
implements Extension {
    public QueueMetaData getQueueMetaData(String queueName) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            TopicMetadata topicMetadata = this.getTopicMetadata(queueName);
            if (topicMetadata == null) {
                return null;
            }
            return TopicMetadataConverter.convert(topicMetadata);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertRuntimeException(cause);
        }
    }

    protected abstract TopicMetadata getTopicMetadata(String var1);
}

