/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.extension;

import com.google.common.collect.Lists;
import io.openmessaging.extension.QueueMetaData;
import io.openmessaging.joyqueue.extension.PartitionAdapter;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;

public class QueueMetaDataAdapter
implements QueueMetaData {
    private TopicMetadata topicMetadata;

    public QueueMetaDataAdapter(TopicMetadata topicMetadata) {
        this.topicMetadata = topicMetadata;
    }

    public String queueName() {
        return this.topicMetadata.getTopic();
    }

    public List<QueueMetaData.Partition> partitions() {
        List<PartitionMetadata> partitions = this.topicMetadata.getPartitions();
        ArrayList result = Lists.newArrayListWithCapacity((int)partitions.size());
        for (PartitionMetadata partition : partitions) {
            result.add(new PartitionAdapter(partition));
        }
        return result;
    }

    public int hashCode() {
        return this.topicMetadata.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueueMetaDataAdapter)) {
            return false;
        }
        return this.topicMetadata.equals(((QueueMetaDataAdapter)obj).getTopicMetadata());
    }

    public String toString() {
        return this.topicMetadata.toString();
    }

    public TopicMetadata getTopicMetadata() {
        return this.topicMetadata;
    }
}

