/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.message;

import com.google.common.base.Preconditions;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.producer.extension.ExtensionMessageFactory;
import io.openmessaging.joyqueue.producer.message.MessageAdapter;
import io.openmessaging.joyqueue.producer.message.OMSProduceMessage;
import io.openmessaging.message.Message;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtensionMessageFactoryImpl
implements ExtensionMessageFactory {
    public Message createMessage(String queueName, byte[] body) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((byte[])body), (Object)"body can not be null");
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
        OMSProduceMessage omsProduceMessage = new OMSProduceMessage();
        omsProduceMessage.setTopic(queueName);
        omsProduceMessage.setBodyBytes(body);
        MessageAdapter messageAdapter = new MessageAdapter(omsProduceMessage);
        omsProduceMessage.setOmsMessage(messageAdapter);
        return messageAdapter;
    }

    @Override
    public Message createMessage(String queueName, String body) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)body), (Object)"body can not be null");
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
        OMSProduceMessage omsProduceMessage = new OMSProduceMessage();
        omsProduceMessage.setTopic(queueName);
        omsProduceMessage.setBody(body);
        MessageAdapter messageAdapter = new MessageAdapter(omsProduceMessage);
        omsProduceMessage.setOmsMessage(messageAdapter);
        return messageAdapter;
    }
}

