/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.message;

import io.openmessaging.KeyValue;
import io.openmessaging.consumer.MessageReceipt;
import io.openmessaging.extension.ExtensionHeader;
import io.openmessaging.joyqueue.message.EmptyMessageReceipt;
import io.openmessaging.joyqueue.message.ExtensionMessage;
import io.openmessaging.joyqueue.producer.message.MessageExtensionHeaderAdapter;
import io.openmessaging.joyqueue.producer.message.MessageHeaderAdapter;
import io.openmessaging.joyqueue.producer.message.MessagePropertiesAdapter;
import io.openmessaging.message.Header;
import java.util.Optional;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public class MessageAdapter
implements ExtensionMessage {
    private ProduceMessage message;
    private Header header;
    private Optional<ExtensionHeader> extensionHeader;
    private KeyValue properties;
    private MessageReceipt receipt;

    public MessageAdapter(ProduceMessage message) {
        this.message = message;
    }

    public Header header() {
        if (this.header == null) {
            this.header = new MessageHeaderAdapter(this.message);
        }
        return this.header;
    }

    public Optional<ExtensionHeader> extensionHeader() {
        if (this.extensionHeader == null) {
            this.extensionHeader = Optional.of(new MessageExtensionHeaderAdapter(this.message));
        }
        return this.extensionHeader;
    }

    public KeyValue properties() {
        if (this.properties == null) {
            this.properties = new MessagePropertiesAdapter(this.message);
        }
        return this.properties;
    }

    public byte[] getData() {
        return this.message.getBodyBytes();
    }

    public void setData(byte[] data) {
        this.message.setBodyBytes(data);
    }

    @Override
    public void setStringData(String data) {
        this.message.setBodyBytes(null);
        this.message.setBody(data);
    }

    @Override
    public String getStringData() {
        return this.message.getBody();
    }

    public MessageReceipt getMessageReceipt() {
        if (this.receipt == null) {
            this.receipt = new EmptyMessageReceipt();
        }
        return this.receipt;
    }

    public String toString() {
        return this.message.toString();
    }

    public ProduceMessage getProduceMessage() {
        return this.message;
    }
}

