/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.message;

import io.openmessaging.KeyValue;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public class MessagePropertiesAdapter
implements KeyValue {
    private ProduceMessage message;

    public MessagePropertiesAdapter(ProduceMessage message) {
        this.message = message;
    }

    public KeyValue put(String key, boolean value) {
        return this.put(key, String.valueOf(value));
    }

    public KeyValue put(String key, short value) {
        return this.put(key, String.valueOf(value));
    }

    public KeyValue put(String key, int value) {
        return this.put(key, String.valueOf(value));
    }

    public KeyValue put(String key, long value) {
        return this.put(key, String.valueOf(value));
    }

    public KeyValue put(String key, double value) {
        return this.put(key, String.valueOf(value));
    }

    public KeyValue put(String key, String value) {
        this.message.putAttribute(key, value);
        return this;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.message.getAttribute(key);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        String value = this.message.getAttribute(key);
        return value == null ? defaultValue : Short.valueOf(value);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.message.getAttribute(key);
        return value == null ? 0 : Integer.valueOf(value);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.message.getAttribute(key);
        return value == null ? 0L : Long.valueOf(value);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.message.getAttribute(key);
        return value == null ? 0.0 : Double.valueOf(value);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String value = this.message.getAttribute(key);
        return value == null ? null : value;
    }

    public Set<String> keySet() {
        Map<String, String> attributes = this.message.getAttributes();
        if (attributes == null) {
            return Collections.emptySet();
        }
        return attributes.keySet();
    }

    public boolean containsKey(String key) {
        return this.message.containsAttribute(key);
    }
}

