/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.producer.ExtensionTransactionalResult;
import io.openmessaging.joyqueue.producer.message.MessageAdapter;
import io.openmessaging.joyqueue.producer.support.SendResultConverter;
import io.openmessaging.message.Message;
import io.openmessaging.producer.SendResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.TransactionMessageProducer;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public class ExtensionTransactionalResultAdapter
implements ExtensionTransactionalResult {
    private String transactionId;
    private MessageProducer messageProducer;
    private TransactionMessageProducer transactionMessageProducer;

    public ExtensionTransactionalResultAdapter(MessageProducer messageProducer) {
        this(null, messageProducer);
    }

    public ExtensionTransactionalResultAdapter(String transactionId, MessageProducer messageProducer) {
        this.transactionId = transactionId;
        this.messageProducer = messageProducer;
        this.transactionMessageProducer = this.prepare(transactionId);
    }

    protected TransactionMessageProducer prepare(String transactionId) {
        if (StringUtils.isBlank((CharSequence)transactionId)) {
            return this.messageProducer.beginTransaction();
        }
        return this.messageProducer.beginTransaction(transactionId);
    }

    @Override
    public String transactionId() {
        return this.transactionId;
    }

    @Override
    public void commit() {
        try {
            this.transactionMessageProducer.commit();
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    @Override
    public void rollback() {
        try {
            this.transactionMessageProducer.rollback();
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    @Override
    public SendResult send(Message message) {
        try {
            Preconditions.checkArgument((boolean)(message instanceof MessageAdapter), (Object)"message is not supported");
            MessageAdapter messageAdapter = (MessageAdapter)message;
            org.joyqueue.client.internal.producer.domain.SendResult sendResult = this.transactionMessageProducer.send(messageAdapter.getProduceMessage());
            return SendResultConverter.convert(sendResult);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    @Override
    public List<SendResult> send(List<Message> messages) {
        try {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(messages), (Object)"messages can not be null");
            List<ProduceMessage> produceMessages = this.checkAndConvertMessage(messages);
            List<org.joyqueue.client.internal.producer.domain.SendResult> sendResults = this.transactionMessageProducer.batchSend(produceMessages);
            return SendResultConverter.convert(sendResults);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    protected List<ProduceMessage> checkAndConvertMessage(List<Message> messages) {
        ArrayList result = Lists.newArrayListWithCapacity((int)messages.size());
        for (Message message : messages) {
            Preconditions.checkArgument((boolean)(message instanceof MessageAdapter), (Object)"message is not supported");
            result.add(((MessageAdapter)message).getProduceMessage());
        }
        return result;
    }
}

