/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.support;

import io.openmessaging.Future;
import io.openmessaging.FutureListener;

public class FutureAdapter<V>
implements Future<V> {
    private Throwable throwable;
    private FutureValueHolder<V> valueHolder;
    private FutureListener listener;

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.doNotify();
    }

    public void setValue(Object value) {
        this.valueHolder = new FutureValueHolder<Object>(value);
        this.doNotify();
    }

    protected V getValue() {
        if (this.valueHolder == null) {
            return null;
        }
        return this.valueHolder.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doNotify() {
        if (this.listener != null) {
            this.listener.operationComplete((Future)this);
        }
        FutureAdapter futureAdapter = this;
        synchronized (futureAdapter) {
            this.notifyAll();
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return this.valueHolder != null || this.throwable != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get() {
        if (this.isDone()) {
            return this.getValue();
        }
        FutureAdapter futureAdapter = this;
        synchronized (futureAdapter) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long timeout) {
        if (this.isDone()) {
            return this.getValue();
        }
        FutureAdapter futureAdapter = this;
        synchronized (futureAdapter) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getValue();
    }

    public void addListener(FutureListener listener) {
        this.listener = listener;
        if (this.isDone()) {
            listener.operationComplete((Future)this);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    class FutureValueHolder<V> {
        private V value;

        FutureValueHolder(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }
    }
}

