/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.openmessaging.Future;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.extension.Extension;
import io.openmessaging.extension.ExtensionHeader;
import io.openmessaging.extension.QueueMetaData;
import io.openmessaging.interceptor.ProducerInterceptor;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.producer.ExtensionProducer;
import io.openmessaging.joyqueue.producer.ExtensionTransactionalResult;
import io.openmessaging.joyqueue.producer.extension.ExtensionAdapter;
import io.openmessaging.joyqueue.producer.extension.ExtensionMessageFactory;
import io.openmessaging.joyqueue.producer.message.MessageAdapter;
import io.openmessaging.joyqueue.producer.support.ExtensionTransactionalResultAdapter;
import io.openmessaging.joyqueue.producer.support.FutureAdapter;
import io.openmessaging.joyqueue.producer.support.ProducerInterceptorAdapter;
import io.openmessaging.joyqueue.producer.support.SendResultConverter;
import io.openmessaging.joyqueue.producer.support.TransactionalResultAdapter;
import io.openmessaging.joyqueue.support.AbstractServiceLifecycle;
import io.openmessaging.message.Message;
import io.openmessaging.producer.SendResult;
import io.openmessaging.producer.TransactionalResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public class ProducerImpl
extends AbstractServiceLifecycle
implements ExtensionProducer {
    private MessageProducer messageProducer;
    private ExtensionMessageFactory messageFactory;
    private Optional<Extension> extension;

    public ProducerImpl(MessageProducer messageProducer, ExtensionMessageFactory messageFactory) {
        this.messageProducer = messageProducer;
        this.messageFactory = messageFactory;
    }

    protected void doStart() throws Exception {
        try {
            this.messageProducer.start();
        }
        catch (Throwable cause) {
            throw this.handleProduceException(cause);
        }
    }

    protected void doStop() {
        try {
            this.messageProducer.stop();
        }
        catch (Throwable cause) {
            throw this.handleProduceException(cause);
        }
    }

    public SendResult send(Message message) {
        try {
            Preconditions.checkArgument((boolean)(message instanceof MessageAdapter), (Object)"message is not supported");
            MessageAdapter messageAdapter = (MessageAdapter)message;
            org.joyqueue.client.internal.producer.domain.SendResult sendResult = this.messageProducer.send(messageAdapter.getProduceMessage());
            return SendResultConverter.convert(sendResult);
        }
        catch (Throwable cause) {
            throw this.handleProduceException(cause);
        }
    }

    public Future<SendResult> sendAsync(Message message) {
        try {
            Preconditions.checkArgument((boolean)(message instanceof MessageAdapter), (Object)"message is not supported");
            FutureAdapter<SendResult> future = new FutureAdapter<SendResult>();
            MessageAdapter messageAdapter = (MessageAdapter)message;
            this.messageProducer.sendAsync(messageAdapter.getProduceMessage()).whenComplete((result, cause) -> {
                if (cause == null) {
                    future.setValue(SendResultConverter.convert(result));
                } else {
                    future.setThrowable((Throwable)this.handleProduceException((Throwable)cause));
                }
            });
            return future;
        }
        catch (Throwable cause2) {
            throw this.handleProduceException(cause2);
        }
    }

    public void sendOneway(Message message) {
        try {
            Preconditions.checkArgument((boolean)(message instanceof MessageAdapter), (Object)"message is not supported");
            FutureAdapter future = new FutureAdapter();
            MessageAdapter messageAdapter = (MessageAdapter)message;
            this.messageProducer.sendOneway(messageAdapter.getProduceMessage());
        }
        catch (Throwable cause) {
            throw this.handleProduceException(cause);
        }
    }

    public void send(List<Message> messages) {
        try {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(messages), (Object)"messages can not be null");
            List<ProduceMessage> produceMessages = this.checkAndConvertMessage(messages);
            this.messageProducer.batchSend(produceMessages);
        }
        catch (Throwable cause) {
            throw this.handleProduceException(cause);
        }
    }

    public Future<SendResult> sendAsync(List<Message> messages) {
        try {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(messages), (Object)"messages can not be null");
            FutureAdapter<SendResult> future = new FutureAdapter<SendResult>();
            List<ProduceMessage> produceMessages = this.checkAndConvertMessage(messages);
            this.messageProducer.batchSendAsync(produceMessages).whenComplete((result, cause) -> {
                if (cause == null) {
                    future.setValue(SendResultConverter.convert((org.joyqueue.client.internal.producer.domain.SendResult)result.get(0)));
                } else {
                    future.setThrowable((Throwable)this.handleProduceException((Throwable)cause));
                }
            });
            return future;
        }
        catch (Throwable cause2) {
            throw this.handleProduceException(cause2);
        }
    }

    public void sendOneway(List<Message> messages) {
        try {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(messages), (Object)"messages can not be null");
            List<ProduceMessage> produceMessages = this.checkAndConvertMessage(messages);
            this.messageProducer.batchSendOneway(produceMessages);
        }
        catch (Throwable cause) {
            throw this.handleProduceException(cause);
        }
    }

    public void addInterceptor(ProducerInterceptor interceptor) {
        try {
            Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
            this.messageProducer.addInterceptor(new ProducerInterceptorAdapter(interceptor));
        }
        catch (Throwable cause) {
            this.handleProduceException(cause);
        }
    }

    public void removeInterceptor(ProducerInterceptor interceptor) {
        try {
            Preconditions.checkArgument((interceptor != null ? 1 : 0) != 0, (Object)"interceptor can not be null");
            this.messageProducer.removeInterceptor(new ProducerInterceptorAdapter(interceptor));
        }
        catch (Throwable cause) {
            this.handleProduceException(cause);
        }
    }

    public TransactionalResult prepare(Message message) {
        try {
            Preconditions.checkArgument((boolean)(message instanceof MessageAdapter), (Object)"message is not supported");
            String transactionId = ((ExtensionHeader)message.extensionHeader().get()).getTransactionId();
            return new TransactionalResultAdapter(message, transactionId, this.messageProducer);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    @Override
    public ExtensionTransactionalResult prepare() {
        try {
            return new ExtensionTransactionalResultAdapter(this.messageProducer);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    @Override
    public ExtensionTransactionalResult prepare(String transactionId) {
        try {
            return new ExtensionTransactionalResultAdapter(transactionId, this.messageProducer);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    public Message createMessage(String queueName, byte[] body) {
        return this.messageFactory.createMessage(queueName, body);
    }

    @Override
    public Message createMessage(String queueName, String body) {
        return this.messageFactory.createMessage(queueName, body);
    }

    public Optional<Extension> getExtension() {
        if (this.extension == null) {
            this.extension = Optional.of(new ExtensionAdapter(this.messageProducer));
        }
        return this.extension;
    }

    public QueueMetaData getQueueMetaData(String queueName) {
        return this.getExtension().get().getQueueMetaData(queueName);
    }

    protected List<ProduceMessage> checkAndConvertMessage(List<Message> messages) {
        ArrayList result = Lists.newArrayListWithCapacity((int)messages.size());
        for (Message message : messages) {
            Preconditions.checkArgument((boolean)(message instanceof MessageAdapter), (Object)"message is not supported");
            result.add(((MessageAdapter)message).getProduceMessage());
        }
        return result;
    }

    protected OMSRuntimeException handleProduceException(Throwable cause) {
        throw ExceptionConverter.convertProduceException(cause);
    }
}

