/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.support;

import io.openmessaging.interceptor.Context;
import io.openmessaging.interceptor.ProducerInterceptor;
import io.openmessaging.joyqueue.producer.interceptor.ContextAdapter;
import io.openmessaging.joyqueue.producer.message.OMSProduceMessage;
import java.util.List;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.client.internal.producer.interceptor.ProduceContext;

public class ProducerInterceptorAdapter
implements org.joyqueue.client.internal.producer.interceptor.ProducerInterceptor {
    private static final String OMS_CONTEXT_ATTRIBUTE_KEY = "_OMS_CONTEXT_";
    private ProducerInterceptor omsProducerInterceptor;

    public ProducerInterceptorAdapter(ProducerInterceptor omsProducerInterceptor) {
        this.omsProducerInterceptor = omsProducerInterceptor;
    }

    @Override
    public boolean preSend(ProduceContext context) {
        Context omsContext = this.getOrCreateOMSContext(context);
        for (ProduceMessage produceMessage : context.getMessages()) {
            this.omsProducerInterceptor.preSend(((OMSProduceMessage)produceMessage).getOmsMessage(), omsContext);
        }
        return true;
    }

    @Override
    public void postSend(ProduceContext context, List<SendResult> result) {
        Context omsContext = this.getOrCreateOMSContext(context);
        for (ProduceMessage produceMessage : context.getMessages()) {
            this.omsProducerInterceptor.postSend(((OMSProduceMessage)produceMessage).getOmsMessage(), omsContext);
        }
    }

    protected Context getOrCreateOMSContext(ProduceContext context) {
        Context omsContext = (Context)context.getAttribute(OMS_CONTEXT_ATTRIBUTE_KEY);
        if (omsContext == null) {
            omsContext = new ContextAdapter(context);
            context.putAttribute(OMS_CONTEXT_ATTRIBUTE_KEY, omsContext);
        }
        return omsContext;
    }

    public int hashCode() {
        return this.omsProducerInterceptor.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProducerInterceptorAdapter)) {
            return false;
        }
        return this.omsProducerInterceptor.equals(((ProducerInterceptorAdapter)obj).getOmsProducerInterceptor());
    }

    public String toString() {
        return this.omsProducerInterceptor.toString();
    }

    public ProducerInterceptor getOmsProducerInterceptor() {
        return this.omsProducerInterceptor;
    }
}

