/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.openmessaging.Future;
import io.openmessaging.ServiceLifeState;
import io.openmessaging.extension.Extension;
import io.openmessaging.extension.QueueMetaData;
import io.openmessaging.interceptor.ProducerInterceptor;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.producer.ExtensionProducer;
import io.openmessaging.joyqueue.producer.ExtensionTransactionalResult;
import io.openmessaging.joyqueue.producer.support.TransactionStateCheckListenerAdapter;
import io.openmessaging.message.Message;
import io.openmessaging.producer.SendResult;
import io.openmessaging.producer.TransactionStateCheckListener;
import io.openmessaging.producer.TransactionalResult;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.MessageAccessPoint;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;

public class TransactionProducerImpl
implements ExtensionProducer {
    private ExtensionProducer delegate;
    private TransactionStateCheckListener transactionStateCheckListener;
    private MessageProducer messageProducer;
    private MessageAccessPoint messageAccessPoint;
    private TxFeedbackConfig txFeedbackConfig;
    private Set<String> topics = Sets.newConcurrentHashSet();

    public TransactionProducerImpl(ExtensionProducer delegate, TransactionStateCheckListener transactionStateCheckListener, MessageProducer messageProducer, MessageAccessPoint messageAccessPoint, TxFeedbackConfig txFeedbackConfig) {
        this.delegate = delegate;
        this.transactionStateCheckListener = transactionStateCheckListener;
        this.messageProducer = messageProducer;
        this.messageAccessPoint = messageAccessPoint;
        this.txFeedbackConfig = txFeedbackConfig;
    }

    public SendResult send(Message message) {
        return this.delegate.send(message);
    }

    public Future<SendResult> sendAsync(Message message) {
        return this.delegate.sendAsync(message);
    }

    public void sendOneway(Message message) {
        this.delegate.sendOneway(message);
    }

    public void send(List<Message> messages) {
        this.delegate.send(messages);
    }

    public Future<SendResult> sendAsync(List<Message> messages) {
        return this.delegate.sendAsync(messages);
    }

    public void sendOneway(List<Message> messages) {
        this.delegate.sendOneway(messages);
    }

    public void addInterceptor(ProducerInterceptor interceptor) {
        this.delegate.addInterceptor(interceptor);
    }

    public void removeInterceptor(ProducerInterceptor interceptor) {
        this.delegate.removeInterceptor(interceptor);
    }

    public TransactionalResult prepare(Message message) {
        return this.delegate.prepare(message);
    }

    @Override
    public ExtensionTransactionalResult prepare(String transactionId) {
        return this.delegate.prepare(transactionId);
    }

    @Override
    public ExtensionTransactionalResult prepare() {
        return this.delegate.prepare();
    }

    public Message createMessage(String queueName, byte[] body) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((byte[])body), (Object)"body can not be null");
            this.doProcessCreateMessage(queueName);
            return this.delegate.createMessage(queueName, body);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    @Override
    public Message createMessage(String queueName, String body) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueName), (Object)"queueName can not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)body), (Object)"body can not be null");
            this.doProcessCreateMessage(queueName);
            return this.delegate.createMessage(queueName, body);
        }
        catch (Throwable cause) {
            throw ExceptionConverter.convertProduceException(cause);
        }
    }

    protected void doProcessCreateMessage(String queueName) {
        if (!this.topics.add(queueName)) {
            return;
        }
        this.messageAccessPoint.setTransactionCallback(queueName, this.txFeedbackConfig, new TransactionStateCheckListenerAdapter(this.transactionStateCheckListener));
    }

    public Optional<Extension> getExtension() {
        return this.delegate.getExtension();
    }

    public QueueMetaData getQueueMetaData(String queueName) {
        return this.delegate.getQueueMetaData(queueName);
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public ServiceLifeState currentState() {
        return this.delegate.currentState();
    }
}

