/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.producer.support;

import io.openmessaging.joyqueue.config.ExceptionConverter;
import io.openmessaging.joyqueue.producer.message.MessageAdapter;
import io.openmessaging.message.Message;
import io.openmessaging.producer.TransactionalResult;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.TransactionMessageProducer;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;

public class TransactionalResultAdapter
implements TransactionalResult {
    private Message message;
    private String transactionId;
    private MessageProducer messageProducer;
    private TransactionMessageProducer transactionMessageProducer;

    public TransactionalResultAdapter(Message message, String transactionId, MessageProducer messageProducer) {
        this.message = message;
        this.transactionId = transactionId;
        this.messageProducer = messageProducer;
        this.transactionMessageProducer = this.prepare(message, transactionId, messageProducer);
    }

    protected TransactionMessageProducer prepare(Message message, String transactionId, MessageProducer messageProducer) {
        MessageAdapter messageAdapter = (MessageAdapter)message;
        ProduceMessage produceMessage = messageAdapter.getProduceMessage();
        TransactionMessageProducer transactionMessageProducer = messageProducer.beginTransaction(transactionId);
        transactionMessageProducer.send(produceMessage);
        return transactionMessageProducer;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public void commit() {
        try {
            this.transactionMessageProducer.commit();
        }
        catch (Exception e) {
            throw ExceptionConverter.convertProduceException(e);
        }
    }

    public void rollback() {
        try {
            this.transactionMessageProducer.rollback();
        }
        catch (Exception e) {
            throw ExceptionConverter.convertProduceException(e);
        }
    }

    public String messageId() {
        return null;
    }
}

