/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.support;

import io.openmessaging.ServiceLifeState;
import io.openmessaging.ServiceLifecycle;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.joyqueue.config.ExceptionConverter;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Activity;
import org.joyqueue.toolkit.service.Service;

public abstract class AbstractServiceLifecycle
extends Service
implements ServiceLifecycle {
    public void start() {
        try {
            super.start();
        }
        catch (Exception e) {
            throw ExceptionConverter.convertRuntimeException(e);
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        catch (Exception e) {
            throw ExceptionConverter.convertRuntimeException(e);
        }
    }

    public ServiceLifeState currentState() {
        Activity.ServiceState serviceState = super.getServiceState();
        switch (serviceState) {
            case WILL_START: {
                return ServiceLifeState.INITIALIZED;
            }
            case STARTING: {
                return ServiceLifeState.STARTING;
            }
            case STARTED: 
            case START_FAILED: {
                return ServiceLifeState.STARTED;
            }
            case WILL_STOP: 
            case STOPPING: {
                return ServiceLifeState.STOPPING;
            }
            case STOPPED: {
                return ServiceLifeState.STOPPED;
            }
        }
        throw new OMSRuntimeException(JoyQueueCode.CN_UNKNOWN_ERROR.getCode(), String.format("service state error, current: %s", serviceState));
    }
}

