/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.joyqueue.support;

import io.openmessaging.ServiceLifeState;
import io.openmessaging.consumer.BatchMessageListener;
import io.openmessaging.consumer.MessageListener;
import io.openmessaging.consumer.MessageReceipt;
import io.openmessaging.extension.Extension;
import io.openmessaging.extension.QueueMetaData;
import io.openmessaging.interceptor.ConsumerInterceptor;
import io.openmessaging.joyqueue.consumer.ConsumerIndex;
import io.openmessaging.joyqueue.consumer.ExtensionConsumer;
import io.openmessaging.joyqueue.support.MessageAccessPointHolder;
import io.openmessaging.message.Message;
import java.util.List;
import java.util.Optional;

public class ConsumerWrapper
implements ExtensionConsumer {
    private ExtensionConsumer delegate;
    private MessageAccessPointHolder messageAccessPointHolder;

    public ConsumerWrapper(ExtensionConsumer delegate, MessageAccessPointHolder messageAccessPointHolder) {
        this.delegate = delegate;
        this.messageAccessPointHolder = messageAccessPointHolder;
    }

    @Override
    public Message receive(short partition, long timeout) {
        return this.delegate.receive(partition, timeout);
    }

    @Override
    public List<Message> batchReceive(short partition, long timeout) {
        return this.delegate.batchReceive(partition, timeout);
    }

    @Override
    public Message receive(short partition, long index, long timeout) {
        return this.delegate.receive(partition, index, timeout);
    }

    @Override
    public List<Message> batchReceive(short partition, long index, long timeout) {
        return this.delegate.batchReceive(partition, index, timeout);
    }

    public void resume() {
        this.delegate.resume();
    }

    public void suspend() {
        this.delegate.suspend();
    }

    public void suspend(long timeout) {
        this.delegate.suspend(timeout);
    }

    public boolean isSuspended() {
        return this.delegate.isSuspended();
    }

    public void bindQueue(String queueName) {
        this.delegate.bindQueue(queueName);
    }

    public void bindQueue(String queueName, MessageListener listener) {
        this.delegate.bindQueue(queueName, listener);
    }

    public void bindQueue(String queueName, BatchMessageListener listener) {
        this.delegate.bindQueue(queueName, listener);
    }

    public void unbindQueue(String queueName) {
        this.delegate.unbindQueue(queueName);
    }

    public boolean isBindQueue() {
        return this.delegate.isBindQueue();
    }

    public String getBindQueue() {
        return this.delegate.getBindQueue();
    }

    public void addInterceptor(ConsumerInterceptor interceptor) {
        this.delegate.addInterceptor(interceptor);
    }

    public void removeInterceptor(ConsumerInterceptor interceptor) {
        this.delegate.removeInterceptor(interceptor);
    }

    public Message receive(long timeout) {
        return this.delegate.receive(timeout);
    }

    public List<Message> batchReceive(long timeout) {
        return this.delegate.batchReceive(timeout);
    }

    public void ack(MessageReceipt receipt) {
        this.delegate.ack(receipt);
    }

    public Optional<Extension> getExtension() {
        return this.delegate.getExtension();
    }

    public void start() {
        this.delegate.start();
        this.messageAccessPointHolder.startConsumer();
    }

    public void stop() {
        this.delegate.stop();
        this.messageAccessPointHolder.stopConsumer();
    }

    public ServiceLifeState currentState() {
        return this.delegate.currentState();
    }

    public QueueMetaData getQueueMetaData(String queueName) {
        return this.delegate.getQueueMetaData(queueName);
    }

    @Override
    public ConsumerIndex getIndex(short partition) {
        return this.delegate.getIndex(partition);
    }

    @Override
    public void batchAck(List<MessageReceipt> receiptList) {
        this.delegate.batchAck(receiptList);
    }
}

