/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal;

import java.io.InputStream;
import java.util.Properties;
import org.joyqueue.client.internal.transport.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConsts {
    protected static final Logger logger = LoggerFactory.getLogger(ClientConsts.class);
    private static final String VERSION_FILE = "META-INF/joyqueue/version.properties";
    public static final String PACKAGE_VERSION = Client.class.getPackage().getImplementationVersion();
    public static final String VERSION;

    static {
        InputStream versionInputStream = ClientConsts.class.getClassLoader().getResourceAsStream(VERSION_FILE);
        String version = PACKAGE_VERSION;
        try {
            Properties properties = new Properties();
            properties.load(versionInputStream);
            version = properties.getProperty("version", PACKAGE_VERSION);
        }
        catch (Exception e) {
            logger.warn("load version properties error", (Throwable)e);
        }
        finally {
            try {
                versionInputStream.close();
            }
            catch (Exception e) {
                logger.warn("close version properties error", (Throwable)e);
            }
        }
        VERSION = version;
    }
}

