/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.cluster;

import java.util.List;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientState;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.network.command.FetchAssignedPartitionData;
import org.joyqueue.network.command.FetchAssignedPartitionRequest;
import org.joyqueue.network.command.FetchAssignedPartitionResponse;
import org.joyqueue.network.command.FetchClusterRequest;
import org.joyqueue.network.command.FetchClusterResponse;
import org.joyqueue.network.command.FindCoordinatorRequest;
import org.joyqueue.network.command.FindCoordinatorResponse;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;

public class ClusterClient {
    private static final String CLIENT_CLUSTER_CACHE_KEY = "_CLIENT_CLUSTER_CACHE_";
    private Client client;
    private TransportConfig transportConfig;
    private NameServerConfig nameServerConfig;

    public static ClusterClient build(Client client, TransportConfig transportConfig, NameServerConfig nameServerConfig) {
        ClusterClient clusterClient = (ClusterClient)client.getAttribute().get((Object)CLIENT_CLUSTER_CACHE_KEY);
        if (clusterClient == null) {
            clusterClient = new ClusterClient(client, transportConfig, nameServerConfig);
            ClusterClient oldClusterClient = (ClusterClient)client.getAttribute().putIfAbsent((Object)CLIENT_CLUSTER_CACHE_KEY, (Object)clusterClient);
            if (oldClusterClient != null) {
                clusterClient = oldClusterClient;
            }
        }
        return clusterClient;
    }

    public ClusterClient(Client client, TransportConfig transportConfig, NameServerConfig nameServerConfig) {
        this.client = client;
        this.transportConfig = transportConfig;
        this.nameServerConfig = nameServerConfig;
    }

    public FetchAssignedPartitionResponse fetchAssignedPartition(List<FetchAssignedPartitionData> data, String app) {
        FetchAssignedPartitionRequest fetchAssignedPartitionRequest = new FetchAssignedPartitionRequest();
        fetchAssignedPartitionRequest.setApp(app);
        fetchAssignedPartitionRequest.setData(data);
        Command response = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)fetchAssignedPartitionRequest));
        return (FetchAssignedPartitionResponse)response.getPayload();
    }

    public FindCoordinatorResponse findCoordinators(List<String> topics, String app) {
        FindCoordinatorRequest findCoordinatorRequest = new FindCoordinatorRequest();
        findCoordinatorRequest.setTopics(topics);
        findCoordinatorRequest.setApp(app);
        Command response = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)findCoordinatorRequest));
        return (FindCoordinatorResponse)response.getPayload();
    }

    public FetchClusterResponse fetchCluster(List<String> topics, String app) {
        FetchClusterRequest fetchClusterRequest = new FetchClusterRequest();
        fetchClusterRequest.setTopics(topics);
        fetchClusterRequest.setApp(app);
        Command response = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)fetchClusterRequest));
        return (FetchClusterResponse)response.getPayload();
    }

    public Client getClient() {
        return this.client;
    }

    public ClientState getState() {
        return this.client.getState();
    }

    public void close() {
        this.client.stop();
    }
}

