/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.cluster;

import org.joyqueue.client.internal.cluster.ClusterClient;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.NameServerConfigChecker;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientManager;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.URL;
import org.joyqueue.toolkit.service.Service;

public class ClusterClientManager
extends Service {
    private TransportConfig transportConfig;
    private NameServerConfig nameServerConfig;
    private BrokerNode bootstrapNode;
    private ClientManager clientManager;

    public ClusterClientManager(TransportConfig transportConfig, NameServerConfig nameServerConfig) {
        NameServerConfigChecker.check(nameServerConfig);
        this.transportConfig = transportConfig;
        this.nameServerConfig = nameServerConfig;
    }

    public ClusterClient getOrCreateClient() {
        return this.getOrCreateClient(this.bootstrapNode);
    }

    public ClusterClient doGetOrCreateClient() {
        Client client = this.clientManager.doGetOrCreateClient(this.bootstrapNode);
        return ClusterClient.build(client, this.transportConfig, this.nameServerConfig);
    }

    public ClusterClient createClient(BrokerNode node) {
        Client client = this.clientManager.createClient(node);
        return new ClusterClient(client, this.transportConfig, this.nameServerConfig);
    }

    public ClusterClient getOrCreateClient(BrokerNode node) {
        Client client = this.clientManager.getOrCreateClient(node);
        return ClusterClient.build(client, this.transportConfig, this.nameServerConfig);
    }

    public ClusterClient getClient(BrokerNode node) {
        Client client = this.clientManager.getClient(node);
        if (client == null) {
            return null;
        }
        return ClusterClient.build(client, this.transportConfig, this.nameServerConfig);
    }

    protected void validate() throws Exception {
        this.transportConfig = this.transportConfig.copy();
        this.transportConfig.setConnections(1);
        this.transportConfig.setIoThreads(1);
        URL url = URL.valueOf((String)String.format("joyqueue://%s", this.nameServerConfig.getAddress()));
        this.bootstrapNode = url.getPort() == 0 ? new BrokerNode(url.getHost(), -1) : new BrokerNode(url.getHost(), url.getPort());
        this.clientManager = new ClientManager(this.transportConfig, this.nameServerConfig);
    }

    protected void doStart() throws Exception {
        this.clientManager.start();
    }

    protected void doStop() {
        if (this.clientManager != null) {
            this.clientManager.stop();
        }
    }
}

