/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.MetadataCacheManager;
import org.joyqueue.client.internal.cluster.MetadataUpdater;
import org.joyqueue.client.internal.cluster.domain.TopicMetadataHolder;
import org.joyqueue.client.internal.metadata.MetadataManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.NameServerConfigChecker;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ClusterManager.class);
    private NameServerConfig config;
    private ClusterClientManager clusterClientManager;
    private MetadataManager metadataManager;
    private MetadataCacheManager metadataCacheManager;
    private MetadataUpdater metadataUpdater;

    public ClusterManager(NameServerConfig config, ClusterClientManager clusterClientManager) {
        NameServerConfigChecker.check(config);
        Preconditions.checkArgument((clusterClientManager != null ? 1 : 0) != 0, (Object)"clusterClientManager can not be null");
        this.config = config;
        this.clusterClientManager = clusterClientManager;
    }

    public List<TopicMetadata> fetchTopicMetadataList(List<String> topics, String app) {
        Map<String, TopicMetadata> topicMetadataMap = this.fetchTopicMetadata(topics, app);
        ArrayList result = Lists.newArrayListWithCapacity((int)topicMetadataMap.size());
        for (Map.Entry<String, TopicMetadata> entry : topicMetadataMap.entrySet()) {
            TopicMetadata topicMetadata = entry.getValue();
            if (topicMetadata == null) continue;
            result.add(topicMetadata);
        }
        return result;
    }

    public Map<String, TopicMetadata> fetchTopicMetadata(List<String> topics, String app) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        LinkedList needUpdateTopics = null;
        for (String topic : topics) {
            TopicMetadataHolder topicMetadataHolder = this.metadataCacheManager.getTopicMetadata(topic, app);
            if (topicMetadataHolder != null) {
                if (topicMetadataHolder.isExpired()) {
                    this.metadataUpdater.tryUpdateTopicMetadata(topic, app);
                }
                result.put(topic, topicMetadataHolder.getTopicMetadata());
                continue;
            }
            if (needUpdateTopics == null) {
                needUpdateTopics = Lists.newLinkedList();
            }
            needUpdateTopics.add(topic);
        }
        if (CollectionUtils.isNotEmpty(needUpdateTopics)) {
            Map<String, TopicMetadata> topicMetadataMap = this.metadataUpdater.updateTopicMetadata(topics, app);
            result.putAll(topicMetadataMap);
        }
        return result;
    }

    public TopicMetadata fetchTopicMetadata(String topic, String app) {
        TopicMetadataHolder topicMetadataHolder = this.metadataCacheManager.getTopicMetadata(topic, app);
        if (topicMetadataHolder == null) {
            return this.metadataUpdater.updateTopicMetadata(topic, app);
        }
        if (topicMetadataHolder.isExpired()) {
            this.metadataUpdater.tryUpdateTopicMetadata(topic, app);
        }
        return topicMetadataHolder.getTopicMetadata();
    }

    public boolean tryUpdateTopicMetadata(String topic, String app) {
        TopicMetadataHolder topicMetadataHolder = this.metadataCacheManager.getTopicMetadata(topic, app);
        if (topicMetadataHolder != null && !topicMetadataHolder.isExpired(this.config.getTempMetadataInterval())) {
            return false;
        }
        return this.metadataUpdater.tryUpdateTopicMetadata(topic, app);
    }

    public TopicMetadata updateTopicMetadata(String topic, String app) {
        TopicMetadataHolder topicMetadataHolder = this.metadataCacheManager.getTopicMetadata(topic, app);
        if (topicMetadataHolder != null && !topicMetadataHolder.isExpired(this.config.getTempMetadataInterval())) {
            return topicMetadataHolder.getTopicMetadata();
        }
        return this.metadataUpdater.updateTopicMetadata(topic, app);
    }

    public TopicMetadata forceUpdateTopicMetadata(String topic, String app) {
        return this.metadataUpdater.updateTopicMetadata(topic, app);
    }

    public Map<String, TopicMetadata> forceUpdateTopicMetadata(List<String> topics, String app) {
        return this.metadataUpdater.updateTopicMetadata(topics, app);
    }

    protected void validate() throws Exception {
        this.metadataCacheManager = new MetadataCacheManager(this.config);
        this.metadataManager = new MetadataManager(this.clusterClientManager);
        this.metadataUpdater = new MetadataUpdater(this.config, this.metadataManager, this.metadataCacheManager);
    }

    protected void doStart() throws Exception {
        this.metadataUpdater.start();
    }

    protected void doStop() {
        if (this.metadataUpdater != null) {
            this.metadataUpdater.stop();
        }
    }
}

