/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.cluster;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.client.internal.cluster.domain.TopicMetadataHolder;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.time.SystemClock;

public class MetadataCacheManager {
    private NameServerConfig config;
    private ConcurrentMap<String, ConcurrentMap<String, TopicMetadataHolder>> topicMetadataCache = Maps.newConcurrentMap();

    public MetadataCacheManager(NameServerConfig config) {
        this.config = config;
    }

    public List<String> getTopics(String app) {
        return Lists.newArrayList(this.getTopicMap(app).keySet());
    }

    public TopicMetadataHolder getTopicMetadata(String topic, String app) {
        return (TopicMetadataHolder)this.getTopicMap(app).get(topic);
    }

    public void putTopicMetadata(String topic, String app, TopicMetadata topicMetadata) {
        this.getTopicMap(app).put(topic, this.newTopicMetadataHolder(topic, topicMetadata));
    }

    public void putTopicMetadata(Map<String, TopicMetadata> topicMetadata, String app) {
        ConcurrentMap<String, TopicMetadataHolder> topicMap = this.getTopicMap(app);
        for (Map.Entry<String, TopicMetadata> entry : topicMetadata.entrySet()) {
            topicMap.put(entry.getKey(), this.newTopicMetadataHolder(entry.getKey(), entry.getValue()));
        }
    }

    public void setTopicMetadata(Map<String, TopicMetadata> topicMetadata, String app) {
        ConcurrentMap newTopicMap = Maps.newConcurrentMap();
        for (Map.Entry<String, TopicMetadata> entry : topicMetadata.entrySet()) {
            newTopicMap.put(entry.getKey(), this.newTopicMetadataHolder(entry.getKey(), entry.getValue()));
        }
        this.topicMetadataCache.put(app, newTopicMap);
    }

    protected ConcurrentMap<String, TopicMetadataHolder> getTopicMap(String app) {
        ConcurrentMap<String, TopicMetadataHolder> oldTopicMap;
        ConcurrentMap<String, TopicMetadataHolder> topicMap = (ConcurrentMap<String, TopicMetadataHolder>)this.topicMetadataCache.get(app);
        if (topicMap == null && (oldTopicMap = this.topicMetadataCache.putIfAbsent(app, topicMap = Maps.newConcurrentMap())) != null) {
            topicMap = oldTopicMap;
        }
        return topicMap;
    }

    protected TopicMetadataHolder newTopicMetadataHolder(String topic, TopicMetadata topicMetadata) {
        if (topicMetadata.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
            if (topicMetadata.isAllAvailable()) {
                return new TopicMetadataHolder(topic, topicMetadata, SystemClock.now(), this.config.getUpdateMetadataInterval(), topicMetadata.getCode());
            }
            return new TopicMetadataHolder(topic, topicMetadata, SystemClock.now(), this.config.getTempMetadataInterval(), topicMetadata.getCode());
        }
        return new TopicMetadataHolder(topic, null, SystemClock.now(), this.config.getTempMetadataInterval(), topicMetadata.getCode());
    }
}

