/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.cluster;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joyqueue.client.internal.cluster.MetadataCacheManager;
import org.joyqueue.client.internal.cluster.TopicAndApp;
import org.joyqueue.client.internal.metadata.MetadataManager;
import org.joyqueue.client.internal.metadata.domain.ClusterMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUpdater
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(MetadataUpdater.class);
    private NameServerConfig config;
    private MetadataManager metadataManager;
    private MetadataCacheManager metadataCacheManager;
    private Set<TopicAndApp> updateFilter = Sets.newConcurrentHashSet();
    private ExecutorService updateThreadPool;
    public static boolean printLog = false;
    public static int printLogInterval = 60000;
    private long lastPrintLog;

    public MetadataUpdater(NameServerConfig config, MetadataManager metadataManager, MetadataCacheManager metadataCacheManager) {
        this.config = config;
        this.metadataManager = metadataManager;
        this.metadataCacheManager = metadataCacheManager;
    }

    protected void validate() throws Exception {
        this.updateThreadPool = new ThreadPoolExecutor(this.config.getUpdateMetadataThread(), this.config.getUpdateMetadataThread(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.config.getUpdateMetadataQueueSize()), (ThreadFactory)new NamedThreadFactory("joyqueue-cluster-updater"));
    }

    protected void doStop() {
        if (this.updateThreadPool != null) {
            this.updateThreadPool.shutdown();
        }
    }

    public boolean tryUpdateTopicMetadata(final String topic, final String app) {
        final TopicAndApp topicAndApp = new TopicAndApp(topic, app);
        if (!this.updateFilter.add(topicAndApp)) {
            return false;
        }
        this.printLog();
        this.updateThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                MetadataUpdater.this.updateTopicMetadata(topic, app);
                MetadataUpdater.this.updateFilter.remove(topicAndApp);
            }
        });
        return true;
    }

    public boolean tryUpdateTopicMetadata(final List<String> topics, final String app) {
        final TopicAndApp topicAndApp = new TopicAndApp(topics, app);
        if (!this.updateFilter.add(topicAndApp)) {
            return false;
        }
        this.printLog();
        this.updateThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                MetadataUpdater.this.updateTopicMetadata(topics, app);
                MetadataUpdater.this.updateFilter.remove(topicAndApp);
            }
        });
        return true;
    }

    public TopicMetadata updateTopicMetadata(String topic, String app) {
        logger.debug("update topic metadata, topic: {}, app: {}", (Object)topic, (Object)app);
        try {
            TopicMetadata topicMetadata = this.metadataManager.fetchMetadata(topic, app);
            this.metadataCacheManager.putTopicMetadata(topic, app, topicMetadata);
            if (topicMetadata.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                return topicMetadata;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("update topic metadata exception, topic: {}, app: {}", new Object[]{topic, app, e});
            if (this.metadataCacheManager.getTopicMetadata(topic, app) == null) {
                this.metadataCacheManager.putTopicMetadata(topic, app, new TopicMetadata(JoyQueueCode.CN_SERVICE_NOT_AVAILABLE));
            }
            return null;
        }
    }

    public Map<String, TopicMetadata> updateTopicMetadata(List<String> topics, String app) {
        logger.debug("update topic metadata, topics: {}, app: {}", topics, (Object)app);
        HashMap result = Maps.newHashMap();
        try {
            ClusterMetadata clusterMetadata = this.metadataManager.fetchMetadata(topics, app);
            for (String topic : topics) {
                TopicMetadata topicMetadata = clusterMetadata.getTopic(topic);
                this.metadataCacheManager.putTopicMetadata(topic, app, topicMetadata);
                if (!topicMetadata.getCode().equals((Object)JoyQueueCode.SUCCESS)) continue;
                result.put(topic, topicMetadata);
            }
        }
        catch (Exception e) {
            logger.error("update topic metadata exception, topics: {}, app: {}", new Object[]{topics, app, e});
            for (String topic : topics) {
                if (this.metadataCacheManager.getTopicMetadata(topic, app) != null) continue;
                this.metadataCacheManager.putTopicMetadata(topic, app, new TopicMetadata(JoyQueueCode.CN_SERVICE_NOT_AVAILABLE));
            }
        }
        return result;
    }

    protected void printLog() {
        if (!printLog) {
            return;
        }
        if (SystemClock.now() - this.lastPrintLog > (long)printLogInterval) {
            logger.info("metadata update filter, current size {}", (Object)this.updateFilter.size());
        }
        this.lastPrintLog = SystemClock.now();
    }
}

