/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.common.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.joyqueue.client.internal.common.compress.Compressor;
import org.joyqueue.client.internal.common.compress.CompressorManager;

public class CompressUtils {
    public static byte[] compress(byte[] bytes, String compressType) throws IOException {
        Compressor compressor = CompressorManager.getCompressor(compressType);
        if (compressor == null) {
            throw new IllegalArgumentException(String.format("compressor %s not exist", compressor));
        }
        return CompressUtils.compress(bytes, compressor);
    }

    public static byte[] decompress(byte[] bytes, String compressType) throws IOException {
        Compressor compressor = CompressorManager.getCompressor(compressType);
        if (compressor == null) {
            throw new IllegalArgumentException(String.format("compressor %s not exist", compressor));
        }
        return CompressUtils.decompress(bytes, compressor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] bytes, Compressor compressor) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);){
            CompressUtils.compress(bytes, 0, bytes.length, bos, compressor);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] bytes, Compressor compressor) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length * 4);){
            CompressUtils.decompress(bytes, 0, bytes.length, bos, compressor);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static void compress(byte[] bytes, int offset, int size, OutputStream out, Compressor compressor) throws IOException {
        compressor.compress(bytes, offset, size, out);
    }

    public static void decompress(byte[] bytes, int offset, int size, OutputStream out, Compressor compressor) throws IOException {
        compressor.decompress(bytes, offset, size, out);
    }
}

