/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.common.compress.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.joyqueue.client.internal.common.compress.Compressor;
import org.joyqueue.toolkit.io.snappy.SnappyFramedInputStream;
import org.joyqueue.toolkit.io.snappy.SnappyFramedOutputStream;

public class SnappyCompressor
implements Compressor {
    public static final String NAME = "snappy";
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(byte[] bytes, int offset, int size, OutputStream out) throws IOException {
        try (SnappyFramedOutputStream sos = new SnappyFramedOutputStream(out);){
            sos.write(bytes, offset, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(byte[] bytes, int offset, int size, OutputStream out) throws IOException {
        try (SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)new ByteArrayInputStream(bytes, offset, size), false);){
            int position;
            byte[] buffer = new byte[1024];
            while ((position = sis.read(buffer)) != -1) {
                out.write(buffer, 0, position);
            }
        }
    }

    public String type() {
        return NAME;
    }
}

