/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.common.compress.support;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import org.joyqueue.client.internal.common.compress.Compressor;
import org.joyqueue.toolkit.io.ZipDeflater;
import org.joyqueue.toolkit.io.ZipInflater;

public class ZlibCompressor
implements Compressor {
    public static final String NAME = "zlib";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(byte[] bytes, int offset, int size, OutputStream out) throws IOException {
        ZipDeflater deflater = new ZipDeflater();
        deflater.reset();
        deflater.setInput(bytes, offset, size);
        deflater.finish();
        byte[] block = new byte[1024];
        try {
            while (!deflater.finished()) {
                int len = deflater.deflate(block);
                out.write(block, 0, len);
            }
        }
        finally {
            deflater.end();
        }
    }

    @Override
    public void decompress(byte[] bytes, int offset, int size, OutputStream out) throws IOException {
        ZipInflater inflater = new ZipInflater();
        inflater.reset();
        inflater.setInput(bytes, offset, size);
        byte[] block = new byte[1024];
        try {
            while (!inflater.finished()) {
                int len = inflater.inflate(block);
                out.write(block, 0, len);
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        finally {
            inflater.end();
        }
    }

    public String type() {
        return NAME;
    }
}

