/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer;

import org.joyqueue.client.internal.consumer.MessageFetcher;
import org.joyqueue.client.internal.consumer.config.FetcherConfig;
import org.joyqueue.client.internal.consumer.support.DefaultMessageFetcher;
import org.joyqueue.client.internal.consumer.support.MessageFetcherWrapper;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManagerFactory;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.client.internal.transport.config.TransportConfig;

public class MessageFetcherFactory {
    public static MessageFetcher create(String address, String app, String token) {
        return MessageFetcherFactory.create(address, app, token, null, null);
    }

    public static MessageFetcher create(String address, String app, String token, String region) {
        return MessageFetcherFactory.create(address, app, token, region, null);
    }

    public static MessageFetcher create(String address, String app, String token, String region, String namespace) {
        return MessageFetcherFactory.create(NameServerHelper.createConfig(address, app, token, region, namespace));
    }

    public static MessageFetcher create(NameServerConfig nameServerConfig) {
        return MessageFetcherFactory.create(nameServerConfig, new FetcherConfig());
    }

    public static MessageFetcher create(NameServerConfig nameServerConfig, FetcherConfig config) {
        return MessageFetcherFactory.create(new TransportConfig(), nameServerConfig, config);
    }

    public static MessageFetcher create(TransportConfig transportConfig, NameServerConfig nameServerConfig, FetcherConfig config) {
        ConsumerClientManager consumerClientManager = ConsumerClientManagerFactory.create(nameServerConfig, transportConfig);
        DefaultMessageFetcher messageFetcher = new DefaultMessageFetcher(consumerClientManager, config);
        return new MessageFetcherWrapper(consumerClientManager, messageFetcher);
    }

    public static MessageFetcher create(ConsumerClientManager consumerClientManager, FetcherConfig config) {
        return new DefaultMessageFetcher(consumerClientManager, config);
    }
}

