/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.config;

import org.apache.commons.lang3.StringUtils;

public class ConsumerConfig {
    public static final int NONE_BATCH_SIZE = -1;
    public static final long NONE_ACK_TIMEOUT = -1L;
    public static final int NONE_BROADCAST_INDEX_EXPIRE_TIME = -1;
    public static final int NONE_THREAD = -1;
    private String app;
    private String group;
    private int batchSize = -1;
    private long ackTimeout = -1L;
    private long timeout = 10000L;
    private long pollTimeout = 10000L;
    private long longPollTimeout = 5000L;
    private long interval = 0L;
    private long idleInterval = 1000L;
    private long sessionTimeout = 60000L;
    private int thread = -1;
    private boolean failover = true;
    private boolean loadBalance = true;
    private String loadBalanceType = "roundrobin";
    private String broadcastGroup;
    private String broadcastLocalPath;
    private int broadcastPersistInterval = 10000;
    private int broadcastIndexExpireTime = -1;
    private volatile String appFullName;

    public ConsumerConfig copy() {
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setApp(this.app);
        consumerConfig.setGroup(this.group);
        consumerConfig.setBatchSize(this.batchSize);
        consumerConfig.setAckTimeout(this.ackTimeout);
        consumerConfig.setTimeout(this.timeout);
        consumerConfig.setPollTimeout(this.pollTimeout);
        consumerConfig.setLongPollTimeout(this.longPollTimeout);
        consumerConfig.setInterval(this.interval);
        consumerConfig.setIdleInterval(this.idleInterval);
        consumerConfig.setSessionTimeout(this.sessionTimeout);
        consumerConfig.setThread(this.thread);
        consumerConfig.setFailover(this.failover);
        consumerConfig.setLoadBalance(this.loadBalance);
        consumerConfig.setLoadBalanceType(this.loadBalanceType);
        consumerConfig.setBroadcastGroup(this.broadcastGroup);
        consumerConfig.setBroadcastLocalPath(this.broadcastLocalPath);
        consumerConfig.setBroadcastPersistInterval(this.broadcastPersistInterval);
        consumerConfig.setBroadcastIndexExpireTime(this.broadcastIndexExpireTime);
        return consumerConfig;
    }

    public String getAppFullName() {
        if (this.appFullName == null) {
            this.appFullName = StringUtils.isBlank((CharSequence)this.group) ? this.app : this.app + "." + this.group;
        }
        return this.appFullName;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        if (this.broadcastGroup == null) {
            this.broadcastGroup = app;
        }
        this.app = app;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public long getLongPollTimeout() {
        return this.longPollTimeout;
    }

    public void setLongPollTimeout(long longPollTimeout) {
        this.longPollTimeout = longPollTimeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getIdleInterval() {
        return this.idleInterval;
    }

    public void setIdleInterval(long idleInterval) {
        this.idleInterval = idleInterval;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setThread(int thread) {
        this.thread = thread;
    }

    public int getThread() {
        return this.thread;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    public boolean isLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalanceType(String loadBalanceType) {
        this.loadBalanceType = loadBalanceType;
    }

    public String getLoadBalanceType() {
        return this.loadBalanceType;
    }

    public String getBroadcastGroup() {
        return this.broadcastGroup;
    }

    public void setBroadcastGroup(String broadcastGroup) {
        this.broadcastGroup = broadcastGroup;
    }

    public void setBroadcastLocalPath(String broadcastLocalPath) {
        this.broadcastLocalPath = broadcastLocalPath;
    }

    public String getBroadcastLocalPath() {
        return this.broadcastLocalPath;
    }

    public int getBroadcastPersistInterval() {
        return this.broadcastPersistInterval;
    }

    public void setBroadcastPersistInterval(int broadcastPersistInterval) {
        this.broadcastPersistInterval = broadcastPersistInterval;
    }

    public int getBroadcastIndexExpireTime() {
        return this.broadcastIndexExpireTime;
    }

    public void setBroadcastIndexExpireTime(int broadcastIndexExpireTime) {
        this.broadcastIndexExpireTime = broadcastIndexExpireTime;
    }
}

