/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BaseMessageListener;
import org.joyqueue.client.internal.consumer.BatchMessageListener;
import org.joyqueue.client.internal.consumer.MessageListener;
import org.joyqueue.client.internal.consumer.MessageListenerContainer;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.exception.ConsumerException;
import org.joyqueue.client.internal.consumer.support.TopicMessageConsumer;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageListenerContainer
extends Service
implements MessageListenerContainer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMessageListenerContainer.class);
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ClusterClientManager clusterClientManager;
    private ConsumerClientManager consumerClientManager;
    private Map<String, TopicMessageConsumer> topicConsumerMap = Maps.newHashMap();

    public DefaultMessageListenerContainer(ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ClusterClientManager clusterClientManager, ConsumerClientManager consumerClientManager) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"consumer not null");
        Preconditions.checkArgument((nameServerConfig != null ? 1 : 0) != 0, (Object)"nameserver not null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager not null");
        Preconditions.checkArgument((clusterClientManager != null ? 1 : 0) != 0, (Object)"clusterClientManager not null");
        Preconditions.checkArgument((consumerClientManager != null ? 1 : 0) != 0, (Object)"consumerClientManager not null");
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.clusterClientManager = clusterClientManager;
        this.consumerClientManager = consumerClientManager;
    }

    protected void doStart() throws Exception {
        for (Map.Entry<String, TopicMessageConsumer> entry : this.topicConsumerMap.entrySet()) {
            if (entry.getValue().isStarted()) continue;
            entry.getValue().start();
        }
    }

    protected void doStop() {
        for (Map.Entry<String, TopicMessageConsumer> entry : this.topicConsumerMap.entrySet()) {
            entry.getValue().stop();
        }
    }

    @Override
    public synchronized void addListener(String topic, MessageListener messageListener) {
        this.doAddListener(topic, messageListener);
    }

    @Override
    public synchronized void addBatchListener(String topic, BatchMessageListener messageListener) {
        this.doAddListener(topic, messageListener);
    }

    protected void doAddListener(String topic, BaseMessageListener messageListener) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic not blank");
        TopicMessageConsumer topicMessageConsumer = this.topicConsumerMap.get(topic);
        if (topicMessageConsumer == null) {
            topicMessageConsumer = this.createTopicMessageConsumer(topic);
            this.topicConsumerMap.put(topic, topicMessageConsumer);
            if (this.isStarted()) {
                try {
                    topicMessageConsumer.start();
                }
                catch (Exception e) {
                    logger.error("start topic message consumer exception, topic : {}", (Object)topic, (Object)e);
                    throw new ConsumerException("start message consumer exception", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
                }
            }
        }
        topicMessageConsumer.addListener(messageListener);
    }

    protected TopicMessageConsumer createTopicMessageConsumer(String topic) {
        return new TopicMessageConsumer(topic, this.config, this.nameServerConfig, this.clusterManager, this.clusterClientManager, this.consumerClientManager);
    }
}

