/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.container;

import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.consumer.BatchMessageListener;
import org.joyqueue.client.internal.consumer.MessageListener;
import org.joyqueue.client.internal.consumer.MessageListenerContainer;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.toolkit.service.Service;

public class MessageListenerContainerWrapper
extends Service
implements MessageListenerContainer {
    private ConsumerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private ClusterClientManager clusterClientManager;
    private ConsumerClientManager consumerClientManager;
    private MessageListenerContainer delegate;

    public MessageListenerContainerWrapper(ConsumerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, ClusterClientManager clusterClientManager, ConsumerClientManager consumerClientManager, MessageListenerContainer delegate) {
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.clusterClientManager = clusterClientManager;
        this.consumerClientManager = consumerClientManager;
        this.delegate = delegate;
    }

    protected void doStart() throws Exception {
        if (this.clusterClientManager != null) {
            this.clusterClientManager.start();
        }
        if (this.clusterManager != null) {
            this.clusterManager.start();
        }
        if (this.consumerClientManager != null) {
            this.consumerClientManager.start();
        }
        this.delegate.start();
    }

    protected void doStop() {
        this.delegate.stop();
        if (this.consumerClientManager != null) {
            this.consumerClientManager.stop();
        }
        if (this.clusterManager != null) {
            this.clusterManager.stop();
        }
        if (this.clusterClientManager != null) {
            this.clusterClientManager.stop();
        }
    }

    @Override
    public void addListener(String topic, MessageListener messageListener) {
        this.delegate.addListener(topic, messageListener);
    }

    @Override
    public void addBatchListener(String topic, BatchMessageListener messageListener) {
        this.delegate.addBatchListener(topic, messageListener);
    }
}

