/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignment;
import org.joyqueue.client.internal.consumer.coordinator.domain.BrokerAssignments;
import org.joyqueue.client.internal.consumer.coordinator.domain.PartitionAssignment;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.network.domain.BrokerNode;

public class BrokerAssignmentConverter {
    public static BrokerAssignments convertBrokerAssignments(TopicMetadata topicMetadata) {
        BrokerAssignments result = new BrokerAssignments();
        HashMap brokerPartitions = Maps.newHashMap();
        for (PartitionMetadata partitionMetadata : topicMetadata.getPartitions()) {
            if (partitionMetadata.getLeader() == null || !partitionMetadata.getLeader().isReadable()) continue;
            List brokerPartitionList = (List)brokerPartitions.get(partitionMetadata.getLeader());
            if (brokerPartitionList == null) {
                brokerPartitionList = Lists.newLinkedList();
                brokerPartitions.put(partitionMetadata.getLeader(), brokerPartitionList);
            }
            brokerPartitionList.add(partitionMetadata.getId());
        }
        ArrayList assignments = Lists.newArrayListWithCapacity((int)brokerPartitions.size());
        for (Map.Entry brokerEntry : brokerPartitions.entrySet()) {
            assignments.add(new BrokerAssignment((BrokerNode)brokerEntry.getKey(), new PartitionAssignment((List)brokerEntry.getValue())));
        }
        result.setAssignments(assignments);
        return result;
    }

    public static BrokerAssignments convertTopicAssignments(TopicMetadata topicMetadata) {
        ArrayList assignments = Lists.newArrayListWithCapacity((int)topicMetadata.getPartitions().size());
        for (PartitionMetadata partitionMetadata : topicMetadata.getPartitions()) {
            if (partitionMetadata.getLeader() == null || !partitionMetadata.getLeader().isReadable()) continue;
            assignments.add(new BrokerAssignment(partitionMetadata.getLeader(), new PartitionAssignment(Lists.newArrayList((Object[])new Short[]{partitionMetadata.getId()}))));
        }
        BrokerAssignments brokerAssignments = new BrokerAssignments();
        brokerAssignments.setAssignments(assignments);
        return brokerAssignments;
    }
}

