/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.converter;

import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.client.internal.consumer.converter.MessageConvertSupport;
import org.joyqueue.client.internal.consumer.domain.ConsumeMessage;
import org.joyqueue.client.internal.consumer.domain.FetchMessageData;
import org.joyqueue.domain.TopicName;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.SourceType;
import org.joyqueue.network.command.FetchPartitionMessageAckData;
import org.joyqueue.network.command.FetchTopicMessageAckData;
import org.joyqueue.network.serializer.BatchMessageSerializer;

public class BrokerMessageConverter {
    private static MessageConvertSupport messageConvertSupport = new MessageConvertSupport();

    public static Table<String, Short, FetchMessageData> convert(String app, Table<String, Short, FetchPartitionMessageAckData> topicMessageTable) {
        HashBasedTable result = HashBasedTable.create();
        if (topicMessageTable == null || topicMessageTable.isEmpty()) {
            return result;
        }
        for (Map.Entry topicEntry : topicMessageTable.rowMap().entrySet()) {
            String topic = (String)topicEntry.getKey();
            Map partitionMap = (Map)topicEntry.getValue();
            for (Map.Entry partitionEntry : partitionMap.entrySet()) {
                result.put((Object)topic, partitionEntry.getKey(), (Object)new FetchMessageData(BrokerMessageConverter.convert(topic, app, ((FetchPartitionMessageAckData)partitionEntry.getValue()).getMessages()), ((FetchPartitionMessageAckData)partitionEntry.getValue()).getCode()));
            }
        }
        return result;
    }

    public static Map<String, FetchMessageData> convert(String app, Map<String, FetchTopicMessageAckData> topicMessageMap) {
        if (MapUtils.isEmpty(topicMessageMap)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, FetchTopicMessageAckData> entry : topicMessageMap.entrySet()) {
            String topic = entry.getKey();
            FetchTopicMessageAckData fetchTopicMessageAckData = entry.getValue();
            FetchMessageData fetchMessageData = new FetchMessageData(BrokerMessageConverter.convert(topic, app, fetchTopicMessageAckData.getMessages()), fetchTopicMessageAckData.getCode());
            result.put(topic, fetchMessageData);
        }
        return result;
    }

    public static List<ConsumeMessage> convert(String topic, String app, List<BrokerMessage> brokerMessages) {
        if (CollectionUtils.isEmpty(brokerMessages)) {
            return Collections.emptyList();
        }
        LinkedList result = Lists.newLinkedList();
        for (BrokerMessage brokerMessage : brokerMessages) {
            if (brokerMessage.isBatch()) {
                List<BrokerMessage> convertedBrokerMessages = BrokerMessageConverter.convertBatch(topic, app, brokerMessage);
                if (convertedBrokerMessages == null) continue;
                for (BrokerMessage convertedBrokerMessage : convertedBrokerMessages) {
                    result.add(BrokerMessageConverter.convert(topic, app, convertedBrokerMessage));
                }
                continue;
            }
            BrokerMessage convertedMessage = messageConvertSupport.convert(brokerMessage);
            if (convertedMessage == null) {
                convertedMessage = brokerMessage;
            }
            result.add(BrokerMessageConverter.convert(topic, app, convertedMessage));
        }
        return result;
    }

    public static List<BrokerMessage> convertBatch(String topic, String app, BrokerMessage batchBrokerMessage) {
        if (batchBrokerMessage.getSource() != SourceType.JOYQUEUE.getValue()) {
            return messageConvertSupport.convertBatch(batchBrokerMessage);
        }
        byte[] body = batchBrokerMessage.getDecompressedBody();
        batchBrokerMessage.setBody(body);
        return BatchMessageSerializer.deserialize((BrokerMessage)batchBrokerMessage);
    }

    public static ConsumeMessage convert(String topic, String app, BrokerMessage brokerMessage) {
        byte[] body = brokerMessage.getDecompressedBody();
        ConsumeMessage consumeMessage = new ConsumeMessage(TopicName.parse((String)topic), app, brokerMessage.getPartition(), brokerMessage.getMsgIndexNo(), brokerMessage.getTxId(), brokerMessage.getBusinessId(), new String(body, Charsets.UTF_8), body, brokerMessage.getFlag(), brokerMessage.getPriority(), brokerMessage.getStartTime(), brokerMessage.getSource(), brokerMessage.getAttributes());
        return consumeMessage;
    }
}

