/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.consumer.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joyqueue.client.internal.Plugins;
import org.joyqueue.client.internal.consumer.converter.MessageConverter;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConvertSupport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Byte, MessageConverter> converterMap = this.loadConverters();

    protected Map<Byte, MessageConverter> loadConverters() {
        HashMap result = Maps.newHashMap();
        Iterable iterable = Plugins.MESSAGE_CONVERTER.extensions();
        for (MessageConverter messageConverter : iterable) {
            result.put(messageConverter.type(), messageConverter);
        }
        return result;
    }

    public List<BrokerMessage> convert(List<BrokerMessage> messages) {
        LinkedList result = Lists.newLinkedList();
        for (BrokerMessage message : messages) {
            if (message.isBatch()) {
                List<BrokerMessage> convertedMessages = this.convertBatch(message);
                if (convertedMessages != null) {
                    result.addAll(convertedMessages);
                    continue;
                }
                result.add(message);
                continue;
            }
            BrokerMessage convertedMessage = this.convert(message);
            if (convertedMessage != null) {
                result.add(convertedMessage);
                continue;
            }
            result.add(message);
        }
        return result;
    }

    public BrokerMessage convert(BrokerMessage message) {
        MessageConverter messageConverter = this.converterMap.get(message.getSource());
        if (messageConverter == null) {
            if (message.getSource() != SourceType.JOYQUEUE.getValue() && message.getSource() != SourceType.JMQ.getValue()) {
                this.logger.warn("message converter not found, source: {}, current: {}", (Object)message.getSource(), this.converterMap);
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("convert message, converter: {}", (Object)message.getSource(), (Object)messageConverter);
        }
        return messageConverter.convert(message);
    }

    public List<BrokerMessage> convertBatch(BrokerMessage message) {
        MessageConverter messageConverter = this.converterMap.get(message.getSource());
        if (messageConverter == null) {
            if (message.getSource() != SourceType.JOYQUEUE.getValue() && message.getSource() != SourceType.JMQ.getValue()) {
                this.logger.warn("message converter not found, source: {}, current: {}", (Object)message.getSource(), this.converterMap);
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("convert message, converter: {}", (Object)message.getSource(), (Object)messageConverter);
        }
        return messageConverter.convertBatch(message);
    }
}

